/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.stream;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.util.stream.StreamListener;

public class NotifyingBufferedInputStream
extends BufferedInputStream {
    int chunkSize;
    int chunk = 0;
    StreamListener listener;

    public NotifyingBufferedInputStream(InputStream is2, int size2, int chunkSize, StreamListener listener) {
        super(is2, size2);
        if (chunkSize <= size2) {
            throw new IllegalArgumentException("chunkSize must be bigger than the buffer");
        }
        this.chunkSize = chunkSize;
        this.listener = listener;
    }

    public void setStreamListener(StreamListener listener) {
        this.listener = listener;
    }

    @Override
    public int read() throws IOException {
        int result2 = super.read();
        if (result2 == -1) {
            return result2;
        }
        this.checkNotification(result2);
        return result2;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result2 = super.read(b, off, len);
        if (result2 == -1) {
            return result2;
        }
        this.checkNotification(result2);
        return result2;
    }

    public void checkNotification(int result2) {
        this.chunk += result2;
        if (this.chunk >= this.chunkSize) {
            if (this.listener != null) {
                this.listener.onStreamNotification(this, this.chunk);
            }
            this.chunk = 0;
        }
    }
}

