/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.propertyeditor;

import java.beans.PropertyEditorSupport;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.Strings;

public class DateEditor
extends PropertyEditorSupport {
    private static DateFormat[] formats;
    private String text;

    public static void initialize() {
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                String defaultFormat = System.getProperty("org.jboss.util.propertyeditor.DateEditor.format", "MMM d, yyyy");
                String defaultLocale = System.getProperty("org.jboss.util.propertyeditor.DateEditor.locale");
                SimpleDateFormat defaultDateFormat = defaultLocale == null || defaultLocale.length() == 0 ? new SimpleDateFormat(defaultFormat) : new SimpleDateFormat(defaultFormat, Strings.parseLocaleString(defaultLocale));
                DateEditor.access$002(new DateFormat[]{defaultDateFormat, new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy"), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z")});
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }

    @Override
    public void setValue(Object value2) {
        if (!(value2 instanceof Date) && value2 != null) {
            throw new IllegalArgumentException("setValue() expected java.util.Date value, got " + value2.getClass().getName());
        }
        this.text = null;
        super.setValue(value2);
    }

    @Override
    public void setAsText(String text) {
        ParseException pe = null;
        for (int i = 0; i < formats.length; ++i) {
            try {
                DateFormat df = formats[i];
                Date date = df.parse(text);
                this.text = text;
                super.setValue(date);
                return;
            }
            catch (ParseException e) {
                pe = e;
                continue;
            }
        }
        throw new NestedRuntimeException(pe);
    }

    @Override
    public String getAsText() {
        if (this.text == null) {
            DateFormat df = formats[formats.length - 1];
            Date date = (Date)this.getValue();
            this.text = df.format(date);
        }
        return this.text;
    }

    static /* synthetic */ DateFormat[] access$002(DateFormat[] x0) {
        formats = x0;
        return x0;
    }

    static {
        DateEditor.initialize();
    }
}

