/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.naming;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.util.naming.Util;

public class NonSerializableFactory
implements ObjectFactory {
    private static Map wrapperMap = Collections.synchronizedMap(new HashMap());

    public static synchronized void bind(String key2, Object target) throws NameAlreadyBoundException {
        if (wrapperMap.containsKey(key2)) {
            throw new NameAlreadyBoundException(key2 + " already exists in the NonSerializableFactory map");
        }
        wrapperMap.put(key2, target);
    }

    public static void rebind(String key2, Object target) {
        wrapperMap.put(key2, target);
    }

    public static void unbind(String key2) throws NameNotFoundException {
        if (wrapperMap.remove(key2) == null) {
            throw new NameNotFoundException(key2 + " was not found in the NonSerializableFactory map");
        }
    }

    public static void unbind(Name name) throws NameNotFoundException {
        String key2 = name.toString();
        if (wrapperMap.remove(key2) == null) {
            throw new NameNotFoundException(key2 + " was not found in the NonSerializableFactory map");
        }
    }

    public static Object lookup(String key2) {
        Object value2 = wrapperMap.get(key2);
        return value2;
    }

    public static Object lookup(Name name) {
        String key2 = name.toString();
        Object value2 = wrapperMap.get(key2);
        return value2;
    }

    public static synchronized void rebind(Context ctx, String key2, Object target) throws NamingException {
        NonSerializableFactory.rebind(key2, target);
        String className = target.getClass().getName();
        String factory = NonSerializableFactory.class.getName();
        StringRefAddr addr = new StringRefAddr("nns", key2);
        Reference memoryRef = new Reference(className, addr, factory, null);
        ctx.rebind(key2, (Object)memoryRef);
    }

    public static synchronized void rebind(Name name, Object target) throws NamingException {
        NonSerializableFactory.rebind(name, target, false);
    }

    public static synchronized void rebind(Context ctx, String key2, Object target, boolean createSubcontexts) throws NamingException {
        Name name = ctx.getNameParser("").parse(key2);
        if (createSubcontexts && name.size() > 1) {
            int size2 = name.size() - 1;
            Util.createSubcontext(ctx, name.getPrefix(size2));
        }
        NonSerializableFactory.rebind(ctx, key2, target);
    }

    public static synchronized void rebind(Name name, Object target, boolean createSubcontexts) throws NamingException {
        String key2 = name.toString();
        InitialContext ctx = new InitialContext();
        if (createSubcontexts && name.size() > 1) {
            int size2 = name.size() - 1;
            Util.createSubcontext((Context)ctx, name.getPrefix(size2));
        }
        NonSerializableFactory.rebind(ctx, key2, target);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Reference ref = (Reference)obj;
        RefAddr addr = ref.get("nns");
        String key2 = (String)addr.getContent();
        Object target = wrapperMap.get(key2);
        return target;
    }
}

