/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.loading;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.util.loading.ContextClassLoader;

public class ContextClassLoaderSwitcher
extends ContextClassLoader {
    public static final RuntimePermission SETCONTEXTCLASSLOADER = new RuntimePermission("setContextClassLoader");
    public static final NewInstance INSTANTIATOR = new NewInstance();

    private ContextClassLoaderSwitcher() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(SETCONTEXTCLASSLOADER);
        }
    }

    public void setContextClassLoader(ClassLoader cl) {
        this.setContextClassLoader(Thread.currentThread(), cl);
    }

    public void setContextClassLoader(final Thread thread2, final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                thread2.setContextClassLoader(cl);
                return null;
            }
        });
    }

    public SwitchContext getSwitchContext() {
        return new SwitchContext();
    }

    public SwitchContext getSwitchContext(ClassLoader cl) {
        return new SwitchContext(cl);
    }

    public SwitchContext getSwitchContext(Class clazz) {
        return new SwitchContext(clazz.getClassLoader());
    }

    private static class NewInstance
    implements PrivilegedAction {
        private NewInstance() {
        }

        public Object run() {
            return new ContextClassLoaderSwitcher();
        }
    }

    public class SwitchContext {
        private ClassLoader origCL;
        private ClassLoader currentCL;
        private Thread currentThread = Thread.currentThread();

        private SwitchContext() {
            this.currentCL = this.origCL = ContextClassLoaderSwitcher.this.getContextClassLoader(this.currentThread);
        }

        private SwitchContext(ClassLoader cl) {
            this();
            this.setClassLoader(cl);
        }

        public Thread getThread() {
            return this.currentThread;
        }

        public ClassLoader getOriginalClassLoader() {
            return this.origCL;
        }

        public ClassLoader getCurrentClassLoader() {
            return this.currentCL;
        }

        public void setClassLoader(ClassLoader cl) {
            if (cl != null && cl != this.currentCL) {
                ContextClassLoaderSwitcher.this.setContextClassLoader(this.currentThread, cl);
                this.currentCL = cl;
            }
        }

        public void reset() {
            if (this.currentCL != null && this.currentCL != this.origCL) {
                ContextClassLoaderSwitcher.this.setContextClassLoader(this.currentThread, this.origCL);
            }
        }

        public void forceReset() {
            ContextClassLoaderSwitcher.this.setContextClassLoader(this.currentThread, this.origCL);
        }
    }
}

