/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.graph;

import org.jboss.util.graph.Vertex;

public class Edge<T> {
    private Vertex<T> from;
    private Vertex<T> to;
    private int cost;
    private boolean mark;

    public Edge(Vertex<T> from2, Vertex<T> to2) {
        this(from2, to2, 0);
    }

    public Edge(Vertex<T> from2, Vertex<T> to2, int cost) {
        this.from = from2;
        this.to = to2;
        this.cost = cost;
        this.mark = false;
    }

    public Vertex<T> getTo() {
        return this.to;
    }

    public Vertex<T> getFrom() {
        return this.from;
    }

    public int getCost() {
        return this.cost;
    }

    public void mark() {
        this.mark = true;
    }

    public void clearMark() {
        this.mark = false;
    }

    public boolean isMarked() {
        return this.mark;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("Edge[from: ");
        tmp.append(this.from.getName());
        tmp.append(",to: ");
        tmp.append(this.to.getName());
        tmp.append(", cost: ");
        tmp.append(this.cost);
        tmp.append("]");
        return tmp.toString();
    }
}

