/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.util.file.ArchiveBrowserFactory;
import org.jboss.util.file.FileProtocolArchiveBrowserFactory;
import org.jboss.util.file.JarProtocolArchiveBrowserFactory;

public abstract class ArchiveBrowser {
    public static Map factoryFinder = new ConcurrentHashMap();

    public static Iterator getBrowser(URL url, Filter filter2) {
        ArchiveBrowserFactory factory = (ArchiveBrowserFactory)factoryFinder.get(url.getProtocol());
        if (factory == null) {
            throw new RuntimeException("Archive browser cannot handle protocol: " + url);
        }
        return factory.create(url, filter2);
    }

    static {
        factoryFinder.put("file", new FileProtocolArchiveBrowserFactory());
        factoryFinder.put("jar", new JarProtocolArchiveBrowserFactory());
    }

    public static interface Filter {
        public boolean accept(String var1);
    }
}

