/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.util.collection.CollectionsFactory;

public abstract class WeakClassCache<T> {
    protected final Map<ClassLoader, Map<String, WeakReference<T>>> cache = new WeakHashMap<ClassLoader, Map<String, WeakReference<T>>>();

    public T get(Class<?> clazz) {
        Object result2;
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        Map<String, WeakReference<T>> classLoaderCache = this.getClassLoaderCache(clazz.getClassLoader());
        WeakReference<T> weak = classLoaderCache.get(clazz.getName());
        if (weak != null && (result2 = weak.get()) != null) {
            return result2;
        }
        result2 = this.instantiate(clazz);
        weak = new WeakReference(result2);
        classLoaderCache.put(clazz.getName(), weak);
        this.generate(clazz, result2);
        return result2;
    }

    public T get(String name, ClassLoader cl) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Null classloader");
        }
        Class<?> clazz = cl.loadClass(name);
        return this.get(clazz);
    }

    protected abstract T instantiate(Class<?> var1);

    protected abstract void generate(Class<?> var1, T var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, WeakReference<T>> getClassLoaderCache(ClassLoader cl) {
        Map<ClassLoader, Map<String, WeakReference<T>>> map2 = this.cache;
        synchronized (map2) {
            Map<String, WeakReference<Object>> result2 = this.cache.get(cl);
            if (result2 == null) {
                result2 = CollectionsFactory.createConcurrentReaderMap();
                this.cache.put(cl, result2);
            }
            return result2;
        }
    }
}

