/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection;

import java.io.Serializable;
import org.jboss.util.HashCode;
import org.jboss.util.NullArgumentException;
import org.jboss.util.Objects;
import org.jboss.util.Strings;

public class CompoundKey
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1181463173922935047L;
    private final Object[] elements;

    public CompoundKey(Object[] elements) {
        if (elements == null) {
            throw new NullArgumentException("elements");
        }
        this.elements = elements;
    }

    public CompoundKey(Object a2, Object b) {
        this(new Object[]{a2, b});
    }

    public CompoundKey(Object a2, Object b, Object c) {
        this(new Object[]{a2, b, c});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CompoundKey key2 = (CompoundKey)obj;
            return Objects.equals(key2.elements, this.elements);
        }
        return false;
    }

    public int hashCode() {
        return HashCode.generate(this.elements);
    }

    public String toString() {
        return super.toString() + Strings.join(this.elements, "[", ",", "]");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

