/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import org.jboss.util.Executable;

public abstract class TimerTask
implements Executable,
Comparable {
    static final int NEW = 1;
    static final int SCHEDULED = 2;
    static final int EXECUTED = 3;
    static final int CANCELLED = 4;
    private final Object m_lock = new Object();
    private int m_state = 1;
    private final long m_period;
    private long m_nextExecutionTime;

    protected TimerTask() {
        this.m_period = 0L;
    }

    protected TimerTask(long period) {
        if (period < 0L) {
            throw new IllegalArgumentException("Period can't be negative");
        }
        this.m_period = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        Object object = this.getLock();
        synchronized (object) {
            boolean ret = this.m_state == 2;
            this.m_state = 4;
            return ret;
        }
    }

    @Override
    public abstract void execute() throws Exception;

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        TimerTask t = (TimerTask)other;
        long diff2 = this.getNextExecutionTime() - t.getNextExecutionTime();
        return (int)diff2;
    }

    Object getLock() {
        return this.m_lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(int state) {
        Object object = this.getLock();
        synchronized (object) {
            this.m_state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getState() {
        Object object = this.getLock();
        synchronized (object) {
            return this.m_state;
        }
    }

    boolean isPeriodic() {
        return this.m_period > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNextExecutionTime() {
        Object object = this.getLock();
        synchronized (object) {
            return this.m_nextExecutionTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNextExecutionTime(long time) {
        Object object = this.getLock();
        synchronized (object) {
            this.m_nextExecutionTime = time;
        }
    }

    protected long getPeriod() {
        return this.m_period;
    }
}

