/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.util.HashMap;
import java.util.Map;
import org.jboss.util.CachePolicy;

public class LRUCachePolicy
implements CachePolicy {
    protected Map m_map;
    protected LRUList m_list;
    protected int m_maxCapacity;
    protected int m_minCapacity;

    public LRUCachePolicy() {
    }

    public LRUCachePolicy(int min2, int max2) {
        if (min2 < 2 || min2 > max2) {
            throw new IllegalArgumentException("Illegal cache capacities");
        }
        this.m_minCapacity = min2;
        this.m_maxCapacity = max2;
    }

    protected Map createMap() {
        return new HashMap();
    }

    @Override
    public void create() {
        this.m_map = this.createMap();
        this.m_list = this.createList();
        this.m_list.m_maxCapacity = this.m_maxCapacity;
        this.m_list.m_minCapacity = this.m_minCapacity;
        this.m_list.m_capacity = this.m_maxCapacity;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        if (this.m_list != null) {
            this.flush();
        }
    }

    @Override
    public void destroy() {
        if (this.m_map != null) {
            this.m_map.clear();
        }
        if (this.m_list != null) {
            this.m_list.clear();
        }
    }

    @Override
    public Object get(Object key2) {
        if (key2 == null) {
            throw new IllegalArgumentException("Requesting an object using a null key");
        }
        LRUCacheEntry value2 = (LRUCacheEntry)this.m_map.get(key2);
        if (value2 != null) {
            this.m_list.promote(value2);
            return value2.m_object;
        }
        this.cacheMiss();
        return null;
    }

    @Override
    public Object peek(Object key2) {
        if (key2 == null) {
            throw new IllegalArgumentException("Requesting an object using a null key");
        }
        LRUCacheEntry value2 = (LRUCacheEntry)this.m_map.get(key2);
        if (value2 == null) {
            return null;
        }
        return value2.m_object;
    }

    @Override
    public void insert(Object key2, Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot insert a null object in the cache");
        }
        if (key2 == null) {
            throw new IllegalArgumentException("Cannot insert an object in the cache with null key");
        }
        if (this.m_map.containsKey(key2)) {
            throw new IllegalStateException("Attempt to put in the cache an object that is already there");
        }
        this.m_list.demote();
        LRUCacheEntry entry2 = this.createCacheEntry(key2, o);
        this.m_map.put(key2, entry2);
        this.m_list.promote(entry2);
    }

    @Override
    public void remove(Object key2) {
        if (key2 == null) {
            throw new IllegalArgumentException("Removing an object using a null key");
        }
        Object value2 = this.m_map.remove(key2);
        if (value2 != null) {
            this.m_list.remove((LRUCacheEntry)value2);
        }
    }

    @Override
    public void flush() {
        LRUCacheEntry entry2 = null;
        while ((entry2 = this.m_list.m_tail) != null) {
            this.ageOut(entry2);
        }
    }

    @Override
    public int size() {
        return this.m_list.m_count;
    }

    protected LRUList createList() {
        return new LRUList();
    }

    protected void ageOut(LRUCacheEntry entry2) {
        this.remove(entry2.m_key);
    }

    protected void cacheMiss() {
    }

    protected LRUCacheEntry createCacheEntry(Object key2, Object value2) {
        return new LRUCacheEntry(key2, value2);
    }

    public class LRUCacheEntry {
        public LRUCacheEntry m_next;
        public LRUCacheEntry m_prev;
        public Object m_key;
        public Object m_object;
        public long m_time;

        protected LRUCacheEntry(Object key2, Object object) {
            this.m_key = key2;
            this.m_object = object;
            this.m_next = null;
            this.m_prev = null;
            this.m_time = 0L;
        }

        public String toString() {
            return "key: " + this.m_key + ", object: " + (this.m_object == null ? "null" : Integer.toHexString(this.m_object.hashCode())) + ", entry: " + Integer.toHexString(super.hashCode());
        }
    }

    public class LRUList {
        public int m_maxCapacity;
        public int m_minCapacity;
        public int m_capacity;
        public int m_count = 0;
        public LRUCacheEntry m_head = null;
        public LRUCacheEntry m_tail = null;
        public int m_cacheMiss;

        protected LRUList() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void promote(LRUCacheEntry entry2) {
            if (entry2 == null) {
                throw new IllegalArgumentException("Trying to promote a null object");
            }
            if (this.m_capacity < 1) {
                throw new IllegalStateException("Can't work with capacity < 1");
            }
            this.entryPromotion(entry2);
            entry2.m_time = System.currentTimeMillis();
            if (entry2.m_prev == null) {
                if (entry2.m_next != null) return;
                if (this.m_count == 0) {
                    this.m_head = entry2;
                    this.m_tail = entry2;
                    ++this.m_count;
                    this.entryAdded(entry2);
                    return;
                } else {
                    if (this.m_count == 1 && this.m_head == entry2) return;
                    if (this.m_count < this.m_capacity) {
                        entry2.m_prev = null;
                        entry2.m_next = this.m_head;
                        this.m_head.m_prev = entry2;
                        this.m_head = entry2;
                        ++this.m_count;
                        this.entryAdded(entry2);
                        return;
                    } else {
                        if (this.m_count >= this.m_maxCapacity) throw new IllegalStateException("Attempt to put a new cache entry on a full cache");
                        entry2.m_prev = null;
                        entry2.m_next = this.m_head;
                        this.m_head.m_prev = entry2;
                        this.m_head = entry2;
                        ++this.m_count;
                        int oldCapacity = this.m_capacity++;
                        this.entryAdded(entry2);
                        this.capacityChanged(oldCapacity);
                    }
                }
                return;
            } else if (entry2.m_next == null) {
                LRUCacheEntry beforeLast = entry2.m_prev;
                beforeLast.m_next = null;
                entry2.m_prev = null;
                entry2.m_next = this.m_head;
                this.m_head.m_prev = entry2;
                this.m_head = entry2;
                this.m_tail = beforeLast;
                return;
            } else {
                LRUCacheEntry previous = entry2.m_prev;
                previous.m_next = entry2.m_next;
                entry2.m_next.m_prev = previous;
                entry2.m_prev = null;
                entry2.m_next = this.m_head;
                this.m_head.m_prev = entry2;
                this.m_head = entry2;
            }
        }

        protected void demote() {
            if (this.m_capacity < 1) {
                throw new IllegalStateException("Can't work with capacity < 1");
            }
            if (this.m_count > this.m_maxCapacity) {
                throw new IllegalStateException("Cache list entries number (" + this.m_count + ") > than the maximum allowed (" + this.m_maxCapacity + ")");
            }
            if (this.m_count == this.m_maxCapacity) {
                LRUCacheEntry entry2 = this.m_tail;
                LRUCachePolicy.this.ageOut(entry2);
            }
        }

        protected void remove(LRUCacheEntry entry2) {
            if (entry2 == null) {
                throw new IllegalArgumentException("Cannot remove a null entry from the cache");
            }
            if (this.m_count < 1) {
                throw new IllegalStateException("Trying to remove an entry from an empty cache");
            }
            entry2.m_object = null;
            entry2.m_key = null;
            if (this.m_count == 1) {
                this.m_tail = null;
                this.m_head = null;
            } else if (entry2.m_prev == null) {
                this.m_head = entry2.m_next;
                this.m_head.m_prev = null;
                entry2.m_next = null;
            } else if (entry2.m_next == null) {
                this.m_tail = entry2.m_prev;
                this.m_tail.m_next = null;
                entry2.m_prev = null;
            } else {
                entry2.m_next.m_prev = entry2.m_prev;
                entry2.m_prev.m_next = entry2.m_next;
                entry2.m_prev = null;
                entry2.m_next = null;
            }
            --this.m_count;
            this.entryRemoved(entry2);
        }

        protected void entryPromotion(LRUCacheEntry entry2) {
        }

        protected void entryAdded(LRUCacheEntry entry2) {
        }

        protected void entryRemoved(LRUCacheEntry entry2) {
        }

        protected void capacityChanged(int oldCapacity) {
        }

        protected void clear() {
            LRUCacheEntry entry2 = this.m_head;
            this.m_head = null;
            this.m_tail = null;
            this.m_count = 0;
            while (entry2 != null) {
                this.entryRemoved(entry2);
                entry2 = entry2.m_next;
            }
        }

        public String toString() {
            String s2 = Integer.toHexString(super.hashCode());
            s2 = s2 + " size: " + this.m_count;
            LRUCacheEntry entry2 = this.m_head;
            while (entry2 != null) {
                s2 = s2 + "\n" + entry2;
                entry2 = entry2.m_next;
            }
            return s2;
        }
    }
}

