/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ListHashMap<K, V>
implements Map<K, V> {
    private final Object[] listKeys;
    private final Object[] listValues;
    private int size = 0;
    private Map<K, V> innerMap;
    private final int maxListFill;

    public ListHashMap() {
        this(3);
    }

    public ListHashMap(int listSize) {
        this.listKeys = new Object[listSize];
        this.listValues = new Object[listSize];
        this.maxListFill = listSize;
    }

    @Override
    public void clear() {
        this.innerMap = null;
        for (int i = 0; i < this.maxListFill; ++i) {
            this.listValues[i] = null;
            this.listKeys[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsKey(Object key2) {
        if (this.size < this.maxListFill) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.listKeys[i].equals(key2)) continue;
                return true;
            }
            return false;
        }
        return this.innerMap.containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        if (this.size < this.maxListFill) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.listValues[i].equals(value2)) continue;
                return true;
            }
            return false;
        }
        return this.innerMap.containsValue(value2);
    }

    private Map<K, V> makeMap() {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        for (int i = 0; i < this.size; ++i) {
            m.put(this.listKeys[i], this.listValues[i]);
        }
        return m;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Map<K, V> m = this.innerMap != null ? this.innerMap : this.makeMap();
        return m.entrySet();
    }

    @Override
    public V get(Object key2) {
        if (this.size == 0) {
            return null;
        }
        if (this.innerMap == null) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.listKeys[i].equals(key2)) continue;
                return (V)this.listValues[i];
            }
            return null;
        }
        return this.innerMap.get(key2);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Set<K> keySet() {
        Map<K, V> m = this.innerMap != null ? this.innerMap : this.makeMap();
        return m.keySet();
    }

    @Override
    public V put(K key2, V value2) {
        if (this.innerMap == null) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.listKeys[i].equals(key2)) continue;
                Object old = this.listValues[i];
                this.listValues[i] = value2;
                return (V)old;
            }
            if (this.size < this.maxListFill) {
                this.listKeys[this.size] = key2;
                this.listValues[this.size] = value2;
                ++this.size;
                return null;
            }
            this.innerMap = this.makeMap();
        }
        V val = this.innerMap.put(key2, value2);
        this.size = this.innerMap.size();
        return val;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry2 : m.entrySet()) {
            this.put(entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    public V remove(Object key2) {
        if (this.innerMap == null) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.listKeys[i].equals(key2)) continue;
                Object old = this.listValues[i];
                --this.size;
                this.listValues[i] = this.listValues[this.size];
                this.listKeys[i] = this.listKeys[this.size];
                return (V)old;
            }
            return null;
        }
        V old = this.innerMap.remove(key2);
        this.size = this.innerMap.size();
        if (this.size <= this.maxListFill) {
            this.mapToList();
        }
        return old;
    }

    private void mapToList() {
        int i = 0;
        for (Map.Entry<K, V> entry2 : this.innerMap.entrySet()) {
            this.listKeys[i] = entry2.getKey();
            this.listValues[i] = entry2.getValue();
            ++i;
        }
        this.size = this.innerMap.size();
        this.innerMap = null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Collection<V> values() {
        if (this.innerMap == null) {
            ArrayList<Object> list = new ArrayList<Object>(this.size);
            for (int i = 0; i < this.size; ++i) {
                list.add(this.listValues[i]);
            }
            return list;
        }
        return this.innerMap.values();
    }
}

