/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Range;
import groovy.lang.Script;
import groovy.lang.SpreadMap;
import groovy.lang.SpreadMapEvaluatingException;
import groovy.lang.Tuple;
import groovy.lang.Writable;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.NullObject;
import org.codehaus.groovy.runtime.RegexSupport;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.metaclass.MetaClassRegistryImpl;
import org.codehaus.groovy.runtime.metaclass.MissingMethodExecutionFailed;
import org.codehaus.groovy.runtime.powerassert.PowerAssertionError;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.wrappers.PojoWrapper;
import org.w3c.dom.Element;

public class InvokerHelper {
    private static final Object[] EMPTY_MAIN_ARGS = new Object[]{new String[0]};
    public static final Object[] EMPTY_ARGS = new Object[0];
    protected static final Object[] EMPTY_ARGUMENTS = EMPTY_ARGS;
    protected static final Class[] EMPTY_TYPES = new Class[0];
    public static final MetaClassRegistry metaRegistry = GroovySystem.getMetaClassRegistry();

    public static void removeClass(Class clazz) {
        metaRegistry.removeMetaClass(clazz);
        Introspector.flushFromCaches(clazz);
    }

    public static Object invokeMethodSafe(Object object, String methodName, Object arguments2) {
        if (object != null) {
            return InvokerHelper.invokeMethod(object, methodName, arguments2);
        }
        return null;
    }

    public static Object invokeStaticMethod(String klass, String methodName, Object arguments2) throws ClassNotFoundException {
        Class<?> type = Class.forName(klass);
        return InvokerHelper.invokeStaticMethod(type, methodName, arguments2);
    }

    public static Object invokeStaticNoArgumentsMethod(Class type, String methodName) {
        return InvokerHelper.invokeStaticMethod(type, methodName, (Object)EMPTY_ARGS);
    }

    public static Object invokeConstructorOf(String klass, Object arguments2) throws ClassNotFoundException {
        Class<?> type = Class.forName(klass);
        return InvokerHelper.invokeConstructorOf(type, arguments2);
    }

    public static Object invokeNoArgumentsConstructorOf(Class type) {
        return InvokerHelper.invokeConstructorOf(type, (Object)EMPTY_ARGS);
    }

    public static Object invokeClosure(Object closure, Object arguments2) {
        return InvokerHelper.invokeMethod(closure, "doCall", arguments2);
    }

    public static List asList(Object value2) {
        if (value2 == null) {
            return Collections.EMPTY_LIST;
        }
        if (value2 instanceof List) {
            return (List)value2;
        }
        if (value2.getClass().isArray()) {
            return Arrays.asList((Object[])value2);
        }
        if (value2 instanceof Enumeration) {
            ArrayList answer = new ArrayList();
            Enumeration e = (Enumeration)value2;
            while (e.hasMoreElements()) {
                answer.add(e.nextElement());
            }
            return answer;
        }
        return Collections.singletonList(value2);
    }

    public static String toString(Object arguments2) {
        if (arguments2 instanceof Object[]) {
            return InvokerHelper.toArrayString((Object[])arguments2);
        }
        if (arguments2 instanceof Collection) {
            return InvokerHelper.toListString((Collection)arguments2);
        }
        if (arguments2 instanceof Map) {
            return InvokerHelper.toMapString((Map)arguments2);
        }
        return InvokerHelper.format(arguments2, false);
    }

    public static String inspect(Object self) {
        return InvokerHelper.format(self, true);
    }

    public static Object getAttribute(Object object, String attribute) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof Class) {
            return metaRegistry.getMetaClass((Class)object).getAttribute(object, attribute);
        }
        if (object instanceof GroovyObject) {
            return ((GroovyObject)object).getMetaClass().getAttribute(object, attribute);
        }
        return metaRegistry.getMetaClass(object.getClass()).getAttribute(object, attribute);
    }

    public static void setAttribute(Object object, String attribute, Object newValue) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof Class) {
            metaRegistry.getMetaClass((Class)object).setAttribute(object, attribute, newValue);
        } else if (object instanceof GroovyObject) {
            ((GroovyObject)object).getMetaClass().setAttribute(object, attribute, newValue);
        } else {
            metaRegistry.getMetaClass(object.getClass()).setAttribute(object, attribute, newValue);
        }
    }

    public static Object getProperty(Object object, String property) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            return pogo.getProperty(property);
        }
        if (object instanceof Class) {
            Class c = (Class)object;
            return metaRegistry.getMetaClass(c).getProperty(object, property);
        }
        return ((MetaClassRegistryImpl)metaRegistry).getMetaClass(object).getProperty(object, property);
    }

    public static Object getPropertySafe(Object object, String property) {
        if (object != null) {
            return InvokerHelper.getProperty(object, property);
        }
        return null;
    }

    public static void setProperty(Object object, String property, Object newValue) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object;
            pogo.setProperty(property, newValue);
        } else if (object instanceof Class) {
            metaRegistry.getMetaClass((Class)object).setProperty((Class)object, property, newValue);
        } else {
            ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getMetaClass(object).setProperty(object, property, newValue);
        }
    }

    public static void setProperty2(Object newValue, Object object, String property) {
        InvokerHelper.setProperty(object, property, newValue);
    }

    public static void setGroovyObjectProperty(Object newValue, GroovyObject object, String property) {
        object.setProperty(property, newValue);
    }

    public static Object getGroovyObjectProperty(GroovyObject object, String property) {
        return object.getProperty(property);
    }

    public static void setPropertySafe2(Object newValue, Object object, String property) {
        if (object != null) {
            InvokerHelper.setProperty2(newValue, object, property);
        }
    }

    public static Closure getMethodPointer(Object object, String methodName) {
        if (object == null) {
            throw new NullPointerException("Cannot access method pointer for '" + methodName + "' on null object");
        }
        return new MethodClosure(object, methodName);
    }

    public static Object unaryMinus(Object value2) {
        if (value2 instanceof Integer) {
            Integer number = (Integer)value2;
            return -number.intValue();
        }
        if (value2 instanceof Long) {
            Long number = (Long)value2;
            return -number.longValue();
        }
        if (value2 instanceof BigInteger) {
            return ((BigInteger)value2).negate();
        }
        if (value2 instanceof BigDecimal) {
            return ((BigDecimal)value2).negate();
        }
        if (value2 instanceof Double) {
            Double number = (Double)value2;
            return -number.doubleValue();
        }
        if (value2 instanceof Float) {
            Float number = (Float)value2;
            return Float.valueOf(-number.floatValue());
        }
        if (value2 instanceof Short) {
            Short number = (Short)value2;
            return -number.shortValue();
        }
        if (value2 instanceof Byte) {
            Byte number = (Byte)value2;
            return -number.byteValue();
        }
        if (value2 instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            Iterator it = ((ArrayList)value2).iterator();
            while (it.hasNext()) {
                newlist.add(InvokerHelper.unaryMinus(it.next()));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value2, "negative", EMPTY_ARGS);
    }

    public static Object unaryPlus(Object value2) {
        if (value2 instanceof Integer || value2 instanceof Long || value2 instanceof BigInteger || value2 instanceof BigDecimal || value2 instanceof Double || value2 instanceof Float || value2 instanceof Short || value2 instanceof Byte) {
            return value2;
        }
        if (value2 instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            Iterator it = ((ArrayList)value2).iterator();
            while (it.hasNext()) {
                newlist.add(InvokerHelper.unaryPlus(it.next()));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value2, "positive", EMPTY_ARGS);
    }

    public static Matcher findRegex(Object left, Object right) {
        String regexToCompareTo;
        String stringToCompare = left instanceof String ? (String)left : InvokerHelper.toString(left);
        if (right instanceof String) {
            regexToCompareTo = (String)right;
        } else {
            if (right instanceof Pattern) {
                Pattern pattern = (Pattern)right;
                return pattern.matcher(stringToCompare);
            }
            regexToCompareTo = InvokerHelper.toString(right);
        }
        return Pattern.compile(regexToCompareTo).matcher(stringToCompare);
    }

    public static boolean matchRegex(Object left, Object right) {
        if (left == null || right == null) {
            return false;
        }
        Pattern pattern = right instanceof Pattern ? (Pattern)right : Pattern.compile(InvokerHelper.toString(right));
        String stringToCompare = InvokerHelper.toString(left);
        Matcher matcher = pattern.matcher(stringToCompare);
        RegexSupport.setLastMatcher(matcher);
        return matcher.matches();
    }

    public static Tuple createTuple(Object[] array) {
        return new Tuple(array);
    }

    public static SpreadMap spreadMap(Object value2) {
        if (value2 instanceof Map) {
            Object[] values2 = new Object[((Map)value2).keySet().size() * 2];
            int index = 0;
            for (Object key2 : ((Map)value2).keySet()) {
                values2[index++] = key2;
                values2[index++] = ((Map)value2).get(key2);
            }
            return new SpreadMap(values2);
        }
        throw new SpreadMapEvaluatingException("Cannot spread the map " + value2.getClass().getName() + ", value " + value2);
    }

    public static List createList(Object[] values2) {
        ArrayList<Object> answer = new ArrayList<Object>(values2.length);
        answer.addAll(Arrays.asList(values2));
        return answer;
    }

    public static Map createMap(Object[] values2) {
        LinkedHashMap<Object, Object> answer = new LinkedHashMap<Object, Object>(values2.length / 2);
        int i = 0;
        while (i < values2.length - 1) {
            if (values2[i] instanceof SpreadMap && values2[i + 1] instanceof Map) {
                Map smap = (Map)values2[i + 1];
                for (Object key2 : smap.keySet()) {
                    answer.put(key2, smap.get(key2));
                }
                i += 2;
                continue;
            }
            answer.put(values2[i++], values2[i++]);
        }
        return answer;
    }

    public static void assertFailed(Object expression, Object message) {
        if (message == null || "".equals(message)) {
            throw new PowerAssertionError(expression.toString());
        }
        throw new AssertionError((Object)(String.valueOf(message) + ". Expression: " + expression));
    }

    public static Object runScript(Class scriptClass, String[] args) {
        Binding context = new Binding(args);
        Script script = InvokerHelper.createScript(scriptClass, context);
        return InvokerHelper.invokeMethod(script, "run", EMPTY_ARGS);
    }

    public static Script createScript(Class scriptClass, Binding context) {
        Script script = null;
        if (scriptClass == null) {
            script = new Script(){

                @Override
                public Object run() {
                    return null;
                }
            };
        } else {
            try {
                final GroovyObject object = (GroovyObject)scriptClass.newInstance();
                if (object instanceof Script) {
                    script = (Script)object;
                } else {
                    script = new Script(){

                        @Override
                        public Object run() {
                            Object args = this.getBinding().getVariables().get("args");
                            Object argsToPass = EMPTY_MAIN_ARGS;
                            if (args != null && args instanceof String[]) {
                                argsToPass = args;
                            }
                            object.invokeMethod("main", argsToPass);
                            return null;
                        }
                    };
                    Map variables = context.getVariables();
                    MetaClass mc = InvokerHelper.getMetaClass(object);
                    for (Map.Entry o : variables.entrySet()) {
                        Map.Entry entry2 = o;
                        String key2 = entry2.getKey().toString();
                        InvokerHelper.setPropertySafe(key2.startsWith("_") ? script : object, mc, key2, entry2.getValue());
                    }
                }
            }
            catch (Exception e) {
                throw new GroovyRuntimeException("Failed to create Script instance for class: " + scriptClass + ". Reason: " + e, e);
            }
        }
        script.setBinding(context);
        return script;
    }

    public static void setProperties(Object object, Map map2) {
        MetaClass mc = InvokerHelper.getMetaClass(object);
        Iterator i$ = map2.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry entry2 = o = i$.next();
            String key2 = entry2.getKey().toString();
            Object value2 = entry2.getValue();
            InvokerHelper.setPropertySafe(object, mc, key2, value2);
        }
    }

    private static void setPropertySafe(Object object, MetaClass mc, String key2, Object value2) {
        block3: {
            try {
                mc.setProperty(object, key2, value2);
            }
            catch (MissingPropertyException mpe) {
            }
            catch (InvokerInvocationException iie) {
                Throwable cause = iie.getCause();
                if (cause != null && cause instanceof IllegalArgumentException) break block3;
                throw iie;
            }
        }
    }

    public static void write(Writer out, Object object) throws IOException {
        if (object instanceof String) {
            out.write((String)object);
        } else if (object instanceof Object[]) {
            out.write(InvokerHelper.toArrayString((Object[])object));
        } else if (object instanceof Map) {
            out.write(InvokerHelper.toMapString((Map)object));
        } else if (object instanceof Collection) {
            out.write(InvokerHelper.toListString((Collection)object));
        } else if (object instanceof Writable) {
            Writable writable = (Writable)object;
            writable.writeTo(out);
        } else if (object instanceof InputStream || object instanceof Reader) {
            int i;
            Reader reader = object instanceof InputStream ? new InputStreamReader((InputStream)object) : (Reader)object;
            char[] chars = new char[8192];
            while ((i = reader.read(chars)) != -1) {
                out.write(chars, 0, i);
            }
            reader.close();
        } else {
            out.write(InvokerHelper.toString(object));
        }
    }

    public static void append(Appendable out, Object object) throws IOException {
        if (object instanceof String) {
            out.append((String)object);
        } else if (object instanceof Object[]) {
            out.append(InvokerHelper.toArrayString((Object[])object));
        } else if (object instanceof Map) {
            out.append(InvokerHelper.toMapString((Map)object));
        } else if (object instanceof Collection) {
            out.append(InvokerHelper.toListString((Collection)object));
        } else if (object instanceof Writable) {
            Writable writable = (Writable)object;
            StringWriter stringWriter = new StringWriter();
            writable.writeTo(stringWriter);
            out.append(stringWriter.toString());
        } else if (object instanceof InputStream || object instanceof Reader) {
            int i;
            Reader reader = object instanceof InputStream ? new InputStreamReader((InputStream)object) : (Reader)object;
            char[] chars = new char[8192];
            while ((i = reader.read(chars)) != -1) {
                for (int j = 0; j < i; ++j) {
                    out.append(chars[j]);
                }
            }
            reader.close();
        } else {
            out.append(InvokerHelper.toString(object));
        }
    }

    public static Iterator<Object> asIterator(Object o) {
        return (Iterator)InvokerHelper.invokeMethod(o, "iterator", EMPTY_ARGS);
    }

    protected static String format(Object arguments2, boolean verbose) {
        return InvokerHelper.format(arguments2, verbose, -1);
    }

    public static String format(Object arguments2, boolean verbose, int maxSize) {
        if (arguments2 == null) {
            NullObject nullObject = NullObject.getNullObject();
            return (String)nullObject.getMetaClass().invokeMethod((Object)nullObject, "toString", EMPTY_ARGS);
        }
        if (arguments2.getClass().isArray()) {
            if (arguments2 instanceof char[]) {
                return new String((char[])arguments2);
            }
            return InvokerHelper.format(DefaultTypeTransformation.asCollection(arguments2), verbose, maxSize);
        }
        if (arguments2 instanceof Range) {
            Range range2 = (Range)arguments2;
            if (verbose) {
                return range2.inspect();
            }
            return range2.toString();
        }
        if (arguments2 instanceof Collection) {
            return InvokerHelper.formatList((Collection)arguments2, verbose, maxSize);
        }
        if (arguments2 instanceof Map) {
            return InvokerHelper.formatMap((Map)arguments2, verbose, maxSize);
        }
        if (arguments2 instanceof Element) {
            try {
                Method serialize = Class.forName("groovy.xml.XmlUtil").getMethod("serialize", Element.class);
                return (String)serialize.invoke(null, arguments2);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (arguments2 instanceof String) {
            if (verbose) {
                String arg = ((String)arguments2).replaceAll("\\n", "\\\\n");
                arg = arg.replaceAll("\\r", "\\\\r");
                arg = arg.replaceAll("\\t", "\\\\t");
                arg = arg.replaceAll("\\f", "\\\\f");
                arg = arg.replaceAll("'", "\\\\'");
                arg = arg.replaceAll("\\\\", "\\\\");
                return "'" + arg + "'";
            }
            return (String)arguments2;
        }
        return arguments2.toString();
    }

    private static String formatMap(Map map2, boolean verbose, int maxSize) {
        if (map2.isEmpty()) {
            return "[:]";
        }
        StringBuilder buffer = new StringBuilder("[");
        boolean first = true;
        for (Map.Entry o : map2.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            if (maxSize != -1 && buffer.length() > maxSize) {
                buffer.append("...");
                break;
            }
            Map.Entry entry2 = o;
            buffer.append(InvokerHelper.format(entry2.getKey(), verbose));
            buffer.append(":");
            if (entry2.getValue() == map2) {
                buffer.append("(this Map)");
                continue;
            }
            buffer.append(InvokerHelper.format(entry2.getValue(), verbose, InvokerHelper.sizeLeft(maxSize, buffer)));
        }
        buffer.append("]");
        return buffer.toString();
    }

    private static int sizeLeft(int maxSize, StringBuilder buffer) {
        return maxSize == -1 ? maxSize : Math.max(0, maxSize - buffer.length());
    }

    private static String formatList(Collection collection, boolean verbose, int maxSize) {
        return InvokerHelper.formatList(collection, verbose, maxSize, false);
    }

    private static String formatList(Collection collection, boolean verbose, int maxSize, boolean safe) {
        StringBuilder buffer = new StringBuilder("[");
        boolean first = true;
        for (Object item : collection) {
            String str;
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            if (maxSize != -1 && buffer.length() > maxSize) {
                buffer.append("...");
                break;
            }
            if (item == collection) {
                buffer.append("(this Collection)");
                continue;
            }
            try {
                str = InvokerHelper.format(item, verbose, InvokerHelper.sizeLeft(maxSize, buffer));
            }
            catch (Exception ex) {
                String hash;
                if (!safe) {
                    throw new GroovyRuntimeException(ex);
                }
                try {
                    hash = Integer.toHexString(item.hashCode());
                }
                catch (Exception ignored) {
                    hash = "????";
                }
                str = "<" + item.getClass().getName() + "@" + hash + ">";
            }
            buffer.append(str);
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String toTypeString(Object[] arguments2) {
        if (arguments2 == null) {
            return "null";
        }
        StringBuilder argBuf = new StringBuilder();
        for (int i = 0; i < arguments2.length; ++i) {
            if (i > 0) {
                argBuf.append(", ");
            }
            argBuf.append(arguments2[i] != null ? arguments2[i].getClass().getName() : "null");
        }
        return argBuf.toString();
    }

    public static String toMapString(Map arg) {
        return InvokerHelper.toMapString(arg, -1);
    }

    public static String toMapString(Map arg, int maxSize) {
        return InvokerHelper.formatMap(arg, false, maxSize);
    }

    public static String toListString(Collection arg) {
        return InvokerHelper.toListString(arg, -1);
    }

    public static String toListString(Collection arg, int maxSize) {
        return InvokerHelper.toListString(arg, maxSize, false);
    }

    public static String toListString(Collection arg, int maxSize, boolean safe) {
        return InvokerHelper.formatList(arg, false, maxSize, safe);
    }

    public static String toArrayString(Object[] arguments2) {
        if (arguments2 == null) {
            return "null";
        }
        String sbdry = "[";
        String ebdry = "]";
        StringBuilder argBuf = new StringBuilder(sbdry);
        for (int i = 0; i < arguments2.length; ++i) {
            if (i > 0) {
                argBuf.append(", ");
            }
            argBuf.append(InvokerHelper.format(arguments2[i], false));
        }
        argBuf.append(ebdry);
        return argBuf.toString();
    }

    public static String toArrayString(Object[] arguments2, int maxSize, boolean safe) {
        return InvokerHelper.toListString(DefaultTypeTransformation.asCollection(arguments2), maxSize, safe);
    }

    public static List createRange(Object from2, Object to2, boolean inclusive2) {
        try {
            return ScriptBytecodeAdapter.createRange(from2, to2, inclusive2);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object bitwiseNegate(Object value2) {
        if (value2 instanceof Integer) {
            Integer number = (Integer)value2;
            return ~number.intValue();
        }
        if (value2 instanceof Long) {
            Long number = (Long)value2;
            return number ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (value2 instanceof BigInteger) {
            return ((BigInteger)value2).not();
        }
        if (value2 instanceof String) {
            return StringGroovyMethods.bitwiseNegate(value2.toString());
        }
        if (value2 instanceof GString) {
            return StringGroovyMethods.bitwiseNegate(value2.toString());
        }
        if (value2 instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            Iterator it = ((ArrayList)value2).iterator();
            while (it.hasNext()) {
                newlist.add(InvokerHelper.bitwiseNegate(it.next()));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value2, "bitwiseNegate", EMPTY_ARGS);
    }

    public static MetaClassRegistry getMetaRegistry() {
        return metaRegistry;
    }

    public static MetaClass getMetaClass(Object object) {
        if (object instanceof GroovyObject) {
            return ((GroovyObject)object).getMetaClass();
        }
        return ((MetaClassRegistryImpl)GroovySystem.getMetaClassRegistry()).getMetaClass(object);
    }

    public static MetaClass getMetaClass(Class cls) {
        return metaRegistry.getMetaClass(cls);
    }

    public static Object invokeMethod(Object object, String methodName, Object arguments2) {
        if (object == null) {
            object = NullObject.getNullObject();
        }
        if (object instanceof Class) {
            Class theClass = (Class)object;
            MetaClass metaClass = metaRegistry.getMetaClass(theClass);
            return metaClass.invokeStaticMethod(object, methodName, InvokerHelper.asArray(arguments2));
        }
        if (!(object instanceof GroovyObject)) {
            return InvokerHelper.invokePojoMethod(object, methodName, arguments2);
        }
        return InvokerHelper.invokePogoMethod(object, methodName, arguments2);
    }

    static Object invokePojoMethod(Object object, String methodName, Object arguments2) {
        MetaClass metaClass = InvokerHelper.getMetaClass(object);
        return metaClass.invokeMethod(object, methodName, InvokerHelper.asArray(arguments2));
    }

    static Object invokePogoMethod(Object object, String methodName, Object arguments2) {
        GroovyObject groovy = (GroovyObject)object;
        boolean intercepting = groovy instanceof GroovyInterceptable;
        try {
            if (intercepting) {
                return groovy.invokeMethod(methodName, InvokerHelper.asUnwrappedArray(arguments2));
            }
            return groovy.getMetaClass().invokeMethod(object, methodName, InvokerHelper.asArray(arguments2));
        }
        catch (MissingMethodException e) {
            if (e instanceof MissingMethodExecutionFailed) {
                throw (MissingMethodException)e.getCause();
            }
            if (!intercepting && e.getMethod().equals(methodName) && object.getClass() == e.getType()) {
                return groovy.invokeMethod(methodName, InvokerHelper.asUnwrappedArray(arguments2));
            }
            throw e;
        }
    }

    public static Object invokeSuperMethod(Object object, String methodName, Object arguments2) {
        if (object == null) {
            throw new NullPointerException("Cannot invoke method " + methodName + "() on null object");
        }
        Class<?> theClass = object.getClass();
        MetaClass metaClass = metaRegistry.getMetaClass(theClass.getSuperclass());
        return metaClass.invokeMethod(object, methodName, InvokerHelper.asArray(arguments2));
    }

    public static Object invokeStaticMethod(Class type, String method, Object arguments2) {
        MetaClass metaClass = metaRegistry.getMetaClass(type);
        return metaClass.invokeStaticMethod(type, method, InvokerHelper.asArray(arguments2));
    }

    public static Object invokeConstructorOf(Class type, Object arguments2) {
        MetaClass metaClass = metaRegistry.getMetaClass(type);
        return metaClass.invokeConstructor(InvokerHelper.asArray(arguments2));
    }

    public static Object[] asArray(Object arguments2) {
        if (arguments2 == null) {
            return EMPTY_ARGUMENTS;
        }
        if (arguments2 instanceof Object[]) {
            return (Object[])arguments2;
        }
        return new Object[]{arguments2};
    }

    public static Object[] asUnwrappedArray(Object arguments2) {
        Object[] args = InvokerHelper.asArray(arguments2);
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof PojoWrapper)) continue;
            args[i] = ((PojoWrapper)args[i]).unwrap();
        }
        return args;
    }
}

