/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control.customizers.builder;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.util.AbstractFactory;
import groovy.util.FactoryBuilderSupport;
import java.util.Collection;
import java.util.Map;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class ImportCustomizerFactory
extends AbstractFactory {
    @Override
    public boolean isHandlesNodeChildren() {
        return true;
    }

    @Override
    public Object newInstance(FactoryBuilderSupport builder, Object name, Object value2, Map attributes) throws InstantiationException, IllegalAccessException {
        ImportCustomizer customizer = new ImportCustomizer();
        this.addImport(customizer, value2);
        return customizer;
    }

    private void addImport(ImportCustomizer customizer, Object value2) {
        if (value2 == null) {
            return;
        }
        if (value2 instanceof Collection) {
            for (Object e : (Collection)value2) {
                this.addImport(customizer, e);
            }
        } else if (value2 instanceof String) {
            customizer.addImports((String)value2);
        } else if (value2 instanceof Class) {
            customizer.addImports(((Class)value2).getName());
        } else if (value2 instanceof GString) {
            customizer.addImports(value2.toString());
        } else {
            throw new RuntimeException("Unsupported import value type [" + value2 + "]");
        }
    }

    @Override
    public boolean onNodeChildren(FactoryBuilderSupport builder, Object node, Closure childContent) {
        if (node instanceof ImportCustomizer) {
            Closure clone2 = (Closure)childContent.clone();
            clone2.setDelegate(new ImportHelper((ImportCustomizer)node));
            clone2.call();
        }
        return false;
    }

    private static class ImportHelper {
        private final ImportCustomizer customizer;

        private ImportHelper(ImportCustomizer customizer) {
            this.customizer = customizer;
        }

        protected void normal(String ... names) {
            this.customizer.addImports(names);
        }

        protected void normal(Class ... classes) {
            for (Class aClass : classes) {
                this.customizer.addImports(aClass.getName());
            }
        }

        protected void alias(String alias, String name) {
            this.customizer.addImport(alias, name);
        }

        protected void alias(String alias, Class clazz) {
            this.customizer.addImport(alias, clazz.getName());
        }

        protected void star(String ... packages) {
            this.customizer.addStarImports(packages);
        }

        protected void staticStar(String ... classNames) {
            this.customizer.addStaticStars(classNames);
        }

        protected void staticStar(Class ... classes) {
            for (Class aClass : classes) {
                this.customizer.addStaticStars(aClass.getName());
            }
        }

        protected void staticMember(String name, String field2) {
            this.customizer.addStaticImport(name, field2);
        }

        protected void staticMember(String alias, String name, String field2) {
            this.customizer.addStaticImport(alias, name, field2);
        }
    }
}

