/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr.java;

import groovyjarjarantlr.collections.AST;
import groovyjarjarcommonscli.CommandLine;
import groovyjarjarcommonscli.GroovyInternalPosixParser;
import groovyjarjarcommonscli.Options;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.UnicodeEscapingReader;
import org.codehaus.groovy.antlr.java.Groovifier;
import org.codehaus.groovy.antlr.java.Java2GroovyConverter;
import org.codehaus.groovy.antlr.java.JavaLexer;
import org.codehaus.groovy.antlr.java.JavaRecognizer;
import org.codehaus.groovy.antlr.java.PreJava2GroovyConverter;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.antlr.parser.GroovyRecognizer;
import org.codehaus.groovy.antlr.treewalker.MindMapPrinter;
import org.codehaus.groovy.antlr.treewalker.NodePrinter;
import org.codehaus.groovy.antlr.treewalker.PreOrderTraversal;
import org.codehaus.groovy.antlr.treewalker.SourceCodeTraversal;
import org.codehaus.groovy.antlr.treewalker.SourcePrinter;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;

public class Java2GroovyMain {
    public static void main(String[] args) {
        try {
            Options options = new Options();
            GroovyInternalPosixParser cliParser = new GroovyInternalPosixParser();
            CommandLine cli = cliParser.parse(options, args);
            String[] filenames = cli.getArgs();
            if (filenames.length == 0) {
                System.err.println("Needs at least one filename");
            }
            List<String> filenameList = Arrays.asList(filenames);
            for (String filename : filenameList) {
                File f = new File(filename);
                String text = ResourceGroovyMethods.getText(f);
                System.out.println(Java2GroovyMain.convert(filename, text, true, true));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static String convert(String filename, String input2) throws Exception {
        return Java2GroovyMain.convert(filename, input2, false, false);
    }

    public static String convert(String filename, String input2, boolean withHeader, boolean withNewLines) throws Exception {
        JavaRecognizer parser2 = Java2GroovyMain.getJavaParser(input2);
        String[] tokenNames = parser2.getTokenNames();
        parser2.compilationUnit();
        AST ast = parser2.getAST();
        if ("mindmap".equals(System.getProperty("ANTLR.AST".toLowerCase()))) {
            try {
                PrintStream out = new PrintStream(new FileOutputStream(filename + ".mm"));
                MindMapPrinter visitor = new MindMapPrinter(out, tokenNames);
                PreOrderTraversal treewalker = new PreOrderTraversal(visitor);
                treewalker.process(ast);
            }
            catch (FileNotFoundException e) {
                System.out.println("Cannot create " + filename + ".mm");
            }
        }
        Java2GroovyMain.modifyJavaASTintoGroovyAST(tokenNames, ast);
        String[] groovyTokenNames = Java2GroovyMain.getGroovyTokenNames(input2);
        Java2GroovyMain.groovifyFatJavaLikeGroovyAST(ast, groovyTokenNames);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SourcePrinter visitor = new SourcePrinter(new PrintStream(baos), groovyTokenNames, withNewLines);
        SourceCodeTraversal traverser = new SourceCodeTraversal(visitor);
        traverser.process(ast);
        String header2 = "";
        if (withHeader) {
            header2 = "/*\n  Automatically Converted from Java Source \n  \n  by java2groovy v0.0.1   Copyright Jeremy Rayner 2007\n  \n  !! NOT FIT FOR ANY PURPOSE !! \n  'java2groovy' cannot be used to convert one working program into another  */\n\n";
        }
        return header2 + new String(baos.toByteArray());
    }

    private static void groovifyFatJavaLikeGroovyAST(AST ast, String[] groovyTokenNames) {
        Groovifier groovifier = new Groovifier(groovyTokenNames);
        PreOrderTraversal groovifierTraverser = new PreOrderTraversal(groovifier);
        groovifierTraverser.process(ast);
    }

    private static void modifyJavaASTintoGroovyAST(String[] tokenNames, AST ast) {
        PreJava2GroovyConverter preJava2groovyConverter = new PreJava2GroovyConverter(tokenNames);
        PreOrderTraversal preJava2groovyTraverser = new PreOrderTraversal(preJava2groovyConverter);
        preJava2groovyTraverser.process(ast);
        Java2GroovyConverter java2groovyConverter = new Java2GroovyConverter(tokenNames);
        PreOrderTraversal java2groovyTraverser = new PreOrderTraversal(java2groovyConverter);
        java2groovyTraverser.process(ast);
    }

    private static JavaRecognizer getJavaParser(String input2) {
        JavaRecognizer parser2 = null;
        SourceBuffer sourceBuffer = new SourceBuffer();
        UnicodeEscapingReader unicodeReader = new UnicodeEscapingReader(new StringReader(input2), sourceBuffer);
        JavaLexer lexer2 = new JavaLexer(unicodeReader);
        unicodeReader.setLexer(lexer2);
        parser2 = JavaRecognizer.make(lexer2);
        parser2.setSourceBuffer(sourceBuffer);
        return parser2;
    }

    public static String mindmap(String input2) throws Exception {
        JavaRecognizer parser2 = Java2GroovyMain.getJavaParser(input2);
        String[] tokenNames = parser2.getTokenNames();
        parser2.compilationUnit();
        AST ast = parser2.getAST();
        Java2GroovyMain.modifyJavaASTintoGroovyAST(tokenNames, ast);
        String[] groovyTokenNames = Java2GroovyMain.getGroovyTokenNames(input2);
        Java2GroovyMain.groovifyFatJavaLikeGroovyAST(ast, groovyTokenNames);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MindMapPrinter visitor = new MindMapPrinter(new PrintStream(baos), groovyTokenNames);
        SourceCodeTraversal traverser = new SourceCodeTraversal(visitor);
        traverser.process(ast);
        return new String(baos.toByteArray());
    }

    public static String nodePrinter(String input2) throws Exception {
        JavaRecognizer parser2 = Java2GroovyMain.getJavaParser(input2);
        String[] tokenNames = parser2.getTokenNames();
        parser2.compilationUnit();
        AST ast = parser2.getAST();
        Java2GroovyMain.modifyJavaASTintoGroovyAST(tokenNames, ast);
        String[] groovyTokenNames = Java2GroovyMain.getGroovyTokenNames(input2);
        Java2GroovyMain.groovifyFatJavaLikeGroovyAST(ast, groovyTokenNames);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        NodePrinter visitor = new NodePrinter(new PrintStream(baos), groovyTokenNames);
        SourceCodeTraversal traverser = new SourceCodeTraversal(visitor);
        traverser.process(ast);
        return new String(baos.toByteArray());
    }

    private static String[] getGroovyTokenNames(String input2) {
        GroovyRecognizer groovyParser = null;
        SourceBuffer groovySourceBuffer = new SourceBuffer();
        UnicodeEscapingReader groovyUnicodeReader = new UnicodeEscapingReader(new StringReader(input2), groovySourceBuffer);
        GroovyLexer groovyLexer = new GroovyLexer(groovyUnicodeReader);
        groovyUnicodeReader.setLexer(groovyLexer);
        groovyParser = GroovyRecognizer.make(groovyLexer);
        return groovyParser.getTokenNames();
    }
}

