/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.CharSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;

public class CharSetUtils {
    public static CharSet evaluateSet(String[] set2) {
        if (set2 == null) {
            return null;
        }
        return new CharSet(set2);
    }

    public static String squeeze(String str, String set2) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(set2)) {
            return str;
        }
        String[] strs = new String[]{set2};
        return CharSetUtils.squeeze(str, strs);
    }

    public static String squeeze(String str, String[] set2) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(set2)) {
            return str;
        }
        CharSet chars = CharSet.getInstance(set2);
        StrBuilder buffer = new StrBuilder(str.length());
        char[] chrs = str.toCharArray();
        int sz = chrs.length;
        int lastChar = 32;
        int ch = 32;
        for (int i = 0; i < sz; ++i) {
            ch = chrs[i];
            if (chars.contains((char)ch) && ch == lastChar && i != 0) continue;
            buffer.append((char)ch);
            lastChar = ch;
        }
        return buffer.toString();
    }

    public static int count(String str, String set2) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(set2)) {
            return 0;
        }
        String[] strs = new String[]{set2};
        return CharSetUtils.count(str, strs);
    }

    public static int count(String str, String[] set2) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(set2)) {
            return 0;
        }
        CharSet chars = CharSet.getInstance(set2);
        int count2 = 0;
        char[] chrs = str.toCharArray();
        int sz = chrs.length;
        for (int i = 0; i < sz; ++i) {
            if (!chars.contains(chrs[i])) continue;
            ++count2;
        }
        return count2;
    }

    public static String keep(String str, String set2) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0 || StringUtils.isEmpty(set2)) {
            return "";
        }
        String[] strs = new String[]{set2};
        return CharSetUtils.keep(str, strs);
    }

    public static String keep(String str, String[] set2) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0 || ArrayUtils.isEmpty(set2)) {
            return "";
        }
        return CharSetUtils.modify(str, set2, true);
    }

    public static String delete(String str, String set2) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(set2)) {
            return str;
        }
        String[] strs = new String[]{set2};
        return CharSetUtils.delete(str, strs);
    }

    public static String delete(String str, String[] set2) {
        if (StringUtils.isEmpty(str) || ArrayUtils.isEmpty(set2)) {
            return str;
        }
        return CharSetUtils.modify(str, set2, false);
    }

    private static String modify(String str, String[] set2, boolean expect) {
        CharSet chars = CharSet.getInstance(set2);
        StrBuilder buffer = new StrBuilder(str.length());
        char[] chrs = str.toCharArray();
        int sz = chrs.length;
        for (int i = 0; i < sz; ++i) {
            if (chars.contains(chrs[i]) != expect) continue;
            buffer.append(chrs[i]);
        }
        return buffer.toString();
    }

    public static String translate(String str, String searchChars, String replaceChars) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        StrBuilder buffer = new StrBuilder(str.length());
        char[] chrs = str.toCharArray();
        char[] withChrs = replaceChars.toCharArray();
        int sz = chrs.length;
        int withMax = replaceChars.length() - 1;
        for (int i = 0; i < sz; ++i) {
            int idx = searchChars.indexOf(chrs[i]);
            if (idx != -1) {
                if (idx > withMax) {
                    idx = withMax;
                }
                buffer.append(withChrs[idx]);
                continue;
            }
            buffer.append(chrs[i]);
        }
        return buffer.toString();
    }
}

