/*
 * Decompiled with CFR 0.152.
 */
package jasmin;

abstract class ScannerUtils {
    ScannerUtils() {
    }

    public static Number convertInt(String str, int radix) throws NumberFormatException {
        long x;
        boolean forceLong = false;
        if (str.endsWith("L")) {
            forceLong = true;
            str = str.substring(0, str.length() - 1);
        }
        if ((x = Long.parseLong(str, radix)) <= Integer.MAX_VALUE && x >= Integer.MIN_VALUE && !forceLong) {
            return new Integer((int)x);
        }
        return new Long(x);
    }

    public static Number convertNumber(String str) throws NumberFormatException {
        if (str.startsWith("0x")) {
            return ScannerUtils.convertInt(str.substring(2), 16);
        }
        if (str.indexOf(46) != -1) {
            boolean isFloat = false;
            if (str.endsWith("F")) {
                isFloat = true;
                str = str.substring(0, str.length() - 1);
            }
            double x = new Double(str);
            if (isFloat) {
                return new Float((float)x);
            }
            return new Double(x);
        }
        return ScannerUtils.convertInt(str, 10);
    }

    public static String convertDots(String orig_name) {
        return ScannerUtils.convertChars(orig_name, ".", '/');
    }

    public static String convertChars(String orig_name, String chars, char toChar) {
        StringBuffer tmp = new StringBuffer(orig_name);
        for (int i = 0; i < tmp.length(); ++i) {
            if (chars.indexOf(tmp.charAt(i)) == -1) continue;
            tmp.setCharAt(i, toChar);
        }
        return new String(tmp);
    }

    public static String[] splitClassMethodSignature(String name) {
        String[] result2 = new String[3];
        int pos = 0;
        int sigpos = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '.' || c == '/') {
                pos = i;
                continue;
            }
            if (c != '(') continue;
            sigpos = i;
            break;
        }
        result2[0] = ScannerUtils.convertDots(name.substring(0, pos));
        result2[1] = name.substring(pos + 1, sigpos);
        result2[2] = ScannerUtils.convertDots(name.substring(sigpos));
        return result2;
    }

    public static String[] splitClassField(String name) {
        String[] result2 = new String[2];
        int pos = -1;
        boolean sigpos = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != '.' && c != '/') continue;
            pos = i;
        }
        if (pos == -1) {
            result2[0] = null;
            result2[1] = name;
        } else {
            result2[0] = ScannerUtils.convertDots(name.substring(0, pos));
            result2[1] = name.substring(pos + 1);
        }
        return result2;
    }

    public static String[] splitMethodSignature(String name) {
        String[] result2 = new String[2];
        int sigpos = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c != '(') continue;
            sigpos = i;
            break;
        }
        result2[0] = name.substring(0, sigpos);
        result2[1] = ScannerUtils.convertDots(name.substring(sigpos));
        return result2;
    }
}

