/*
 * Decompiled with CFR 0.152.
 */
package heros.solver;

import com.google.common.collect.Maps;
import heros.EdgeFunction;
import heros.IFDSTabulationProblem;
import heros.InterproceduralCFG;
import heros.solver.IFDSSolver;
import heros.solver.JoinHandlingNode;
import java.util.Map;

public class JoinHandlingNodesIFDSSolver<N, D extends JoinHandlingNode<D>, M, I extends InterproceduralCFG<N, M>>
extends IFDSSolver<N, D, M, I> {
    protected final Map<CacheEntry, JoinHandlingNode<D>> cache = Maps.newHashMap();

    public JoinHandlingNodesIFDSSolver(IFDSTabulationProblem<N, D, M, I> ifdsProblem) {
        super(ifdsProblem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void propagate(D sourceVal, N target, D targetVal, EdgeFunction<IFDSSolver.BinaryDomain> f, N relatedCallSite, boolean isUnbalancedReturn) {
        CacheEntry currentCacheEntry = new CacheEntry(target, sourceVal.createJoinKey(), targetVal.createJoinKey());
        boolean propagate = false;
        JoinHandlingNodesIFDSSolver joinHandlingNodesIFDSSolver = this;
        synchronized (joinHandlingNodesIFDSSolver) {
            if (this.cache.containsKey(currentCacheEntry)) {
                JoinHandlingNode<D> existingTargetVal = this.cache.get(currentCacheEntry);
                if (!existingTargetVal.handleJoin(targetVal)) {
                    propagate = true;
                }
            } else {
                this.cache.put(currentCacheEntry, (JoinHandlingNode<D>)targetVal);
                propagate = true;
            }
        }
        if (propagate) {
            super.propagate(sourceVal, target, targetVal, f, relatedCallSite, isUnbalancedReturn);
        }
    }

    private class CacheEntry {
        private N n;
        private JoinHandlingNode.JoinKey sourceKey;
        private JoinHandlingNode.JoinKey targetKey;

        public CacheEntry(N n, JoinHandlingNode.JoinKey sourceKey, JoinHandlingNode.JoinKey targetKey) {
            this.n = n;
            this.sourceKey = sourceKey;
            this.targetKey = targetKey;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.sourceKey == null ? 0 : this.sourceKey.hashCode());
            result2 = 31 * result2 + (this.targetKey == null ? 0 : this.targetKey.hashCode());
            result2 = 31 * result2 + (this.n == null ? 0 : this.n.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheEntry other = (CacheEntry)obj;
            if (this.sourceKey == null ? other.sourceKey != null : !this.sourceKey.equals(other.sourceKey)) {
                return false;
            }
            if (this.targetKey == null ? other.targetKey != null : !this.targetKey.equals(other.targetKey)) {
                return false;
            }
            return !(this.n == null ? other.n != null : !this.n.equals(other.n));
        }
    }
}

