/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import heros.InterproceduralCFG;
import heros.fieldsens.Context;
import heros.fieldsens.Debugger;
import heros.fieldsens.FactMergeHandler;
import heros.fieldsens.IFDSTabulationProblem;
import heros.fieldsens.MethodAnalyzer;
import heros.fieldsens.MethodAnalyzerImpl;
import heros.fieldsens.Scheduler;
import heros.utilities.DefaultValueMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldSensitiveIFDSSolver<FieldRef, D, N, M, I extends InterproceduralCFG<N, M>> {
    protected static final Logger logger = LoggerFactory.getLogger(FieldSensitiveIFDSSolver.class);
    private DefaultValueMap<M, MethodAnalyzer<FieldRef, D, N, M>> methodAnalyzers = new DefaultValueMap<M, MethodAnalyzer<FieldRef, D, N, M>>(){

        @Override
        protected MethodAnalyzer<FieldRef, D, N, M> createItem(M key2) {
            return FieldSensitiveIFDSSolver.this.createMethodAnalyzer(key2);
        }
    };
    private IFDSTabulationProblem<N, FieldRef, D, M, I> tabulationProblem;
    protected Context<FieldRef, D, N, M> context;
    private Debugger<FieldRef, D, N, M, I> debugger;
    private Scheduler scheduler;

    public FieldSensitiveIFDSSolver(IFDSTabulationProblem<N, FieldRef, D, M, I> tabulationProblem, FactMergeHandler<D> factHandler, Debugger<FieldRef, D, N, M, I> debugger, Scheduler scheduler) {
        this.tabulationProblem = tabulationProblem;
        this.scheduler = scheduler;
        this.debugger = debugger == null ? new Debugger.NullDebugger() : debugger;
        this.debugger.setICFG(tabulationProblem.interproceduralCFG());
        this.context = this.initContext(tabulationProblem, factHandler);
        this.submitInitialSeeds();
    }

    private Context<FieldRef, D, N, M> initContext(IFDSTabulationProblem<N, FieldRef, D, M, I> tabulationProblem, FactMergeHandler<D> factHandler) {
        return new Context<FieldRef, D, N, M>(tabulationProblem, this.scheduler, factHandler){

            @Override
            public MethodAnalyzer<FieldRef, D, N, M> getAnalyzer(M method) {
                if (method == null) {
                    throw new IllegalArgumentException("Method must be not null");
                }
                return (MethodAnalyzer)FieldSensitiveIFDSSolver.this.methodAnalyzers.getOrCreate(method);
            }
        };
    }

    protected MethodAnalyzer<FieldRef, D, N, M> createMethodAnalyzer(M method) {
        return new MethodAnalyzerImpl<FieldRef, D, N, M>(method, this.context);
    }

    private void submitInitialSeeds() {
        for (Map.Entry<N, Set<D>> seed : this.tabulationProblem.initialSeeds().entrySet()) {
            N startPoint = seed.getKey();
            MethodAnalyzer<FieldRef, D, N, M> analyzer = this.methodAnalyzers.getOrCreate(this.tabulationProblem.interproceduralCFG().getMethodOf(startPoint));
            for (D val : seed.getValue()) {
                analyzer.addInitialSeed(startPoint, val);
                this.debugger.initialSeed(startPoint);
            }
        }
    }
}

