/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarcommonscli;

import groovyjarjarcommonscli.Option;
import groovyjarjarcommonscli.ParseException;
import groovyjarjarcommonscli.TypeHandler;
import groovyjarjarcommonscli.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class CommandLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List args = new LinkedList();
    private List options = new ArrayList();

    CommandLine() {
    }

    public boolean hasOption(String opt2) {
        return this.options.contains(this.resolveOption(opt2));
    }

    public boolean hasOption(char opt2) {
        return this.hasOption(String.valueOf(opt2));
    }

    public Object getOptionObject(String opt2) {
        try {
            return this.getParsedOptionValue(opt2);
        }
        catch (ParseException pe) {
            System.err.println("Exception found converting " + opt2 + " to desired type: " + pe.getMessage());
            return null;
        }
    }

    public Object getParsedOptionValue(String opt2) throws ParseException {
        String res = this.getOptionValue(opt2);
        Option option = this.resolveOption(opt2);
        if (option == null) {
            return null;
        }
        Object type = option.getType();
        return res == null ? null : TypeHandler.createValue(res, type);
    }

    public Object getOptionObject(char opt2) {
        return this.getOptionObject(String.valueOf(opt2));
    }

    public String getOptionValue(String opt2) {
        String[] values2 = this.getOptionValues(opt2);
        return values2 == null ? null : values2[0];
    }

    public String getOptionValue(char opt2) {
        return this.getOptionValue(String.valueOf(opt2));
    }

    public String[] getOptionValues(String opt2) {
        ArrayList values2 = new ArrayList();
        Iterator it = this.options.iterator();
        while (it.hasNext()) {
            Option option = (Option)it.next();
            if (!opt2.equals(option.getOpt()) && !opt2.equals(option.getLongOpt())) continue;
            values2.addAll(option.getValuesList());
        }
        return values2.isEmpty() ? null : values2.toArray(new String[values2.size()]);
    }

    private Option resolveOption(String opt2) {
        opt2 = Util.stripLeadingHyphens(opt2);
        Iterator it = this.options.iterator();
        while (it.hasNext()) {
            Option option = (Option)it.next();
            if (opt2.equals(option.getOpt())) {
                return option;
            }
            if (!opt2.equals(option.getLongOpt())) continue;
            return option;
        }
        return null;
    }

    public String[] getOptionValues(char opt2) {
        return this.getOptionValues(String.valueOf(opt2));
    }

    public String getOptionValue(String opt2, String defaultValue) {
        String answer = this.getOptionValue(opt2);
        return answer != null ? answer : defaultValue;
    }

    public String getOptionValue(char opt2, String defaultValue) {
        return this.getOptionValue(String.valueOf(opt2), defaultValue);
    }

    public Properties getOptionProperties(String opt2) {
        Properties props = new Properties();
        Iterator it = this.options.iterator();
        while (it.hasNext()) {
            Option option = (Option)it.next();
            if (!opt2.equals(option.getOpt()) && !opt2.equals(option.getLongOpt())) continue;
            List values2 = option.getValuesList();
            if (values2.size() >= 2) {
                props.put(values2.get(0), values2.get(1));
                continue;
            }
            if (values2.size() != 1) continue;
            props.put(values2.get(0), "true");
        }
        return props;
    }

    public String[] getArgs() {
        String[] answer = new String[this.args.size()];
        this.args.toArray(answer);
        return answer;
    }

    public List getArgList() {
        return this.args;
    }

    void addArg(String arg) {
        this.args.add(arg);
    }

    void addOption(Option opt2) {
        this.options.add(opt2);
    }

    public Iterator iterator() {
        return this.options.iterator();
    }

    public Option[] getOptions() {
        List processed = this.options;
        Option[] optionsArray = new Option[processed.size()];
        return processed.toArray(optionsArray);
    }
}

