/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarantlr;

import groovyjarjarantlr.CharFormatter;

class CppCharFormatter
implements CharFormatter {
    CppCharFormatter() {
    }

    public String escapeChar(int n, boolean bl) {
        switch (n) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return "\\'";
            }
            case 34: {
                return "\\\"";
            }
        }
        if (n < 32 || n > 126) {
            if (n > 255) {
                String string2 = Integer.toString(n, 16);
                while (string2.length() < 4) {
                    string2 = '0' + string2;
                }
                return "\\u" + string2;
            }
            return "\\" + Integer.toString(n, 8);
        }
        return String.valueOf((char)n);
    }

    public String escapeString(String string2) {
        String string3 = new String();
        for (int i = 0; i < string2.length(); ++i) {
            string3 = string3 + this.escapeChar(string2.charAt(i), false);
        }
        return string3;
    }

    public String literalChar(int n) {
        String string2 = "0x" + Integer.toString(n, 16);
        if (n >= 0 && n <= 126) {
            string2 = string2 + " /* '" + this.escapeChar(n, true) + "' */ ";
        }
        return string2;
    }

    public String literalString(String string2) {
        return "\"" + this.escapeString(string2) + "\"";
    }
}

