/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml;

import groovy.util.BuilderSupport;
import groovy.xml.FactorySupport;
import groovy.xml.QName;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMBuilder
extends BuilderSupport {
    Document document;
    DocumentBuilder documentBuilder;

    public static DOMBuilder newInstance() throws ParserConfigurationException {
        return DOMBuilder.newInstance(false, true);
    }

    public static DOMBuilder newInstance(boolean validating, boolean namespaceAware) throws ParserConfigurationException {
        DocumentBuilderFactory factory = FactorySupport.createDocumentBuilderFactory();
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(validating);
        return new DOMBuilder(factory.newDocumentBuilder());
    }

    public static Document parse(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        return DOMBuilder.parse(reader, false, true);
    }

    public static Document parse(Reader reader, boolean validating, boolean namespaceAware) throws SAXException, IOException, ParserConfigurationException {
        return DOMBuilder.parse(reader, validating, namespaceAware, false);
    }

    public static Document parse(Reader reader, boolean validating, boolean namespaceAware, boolean allowDocTypeDeclaration) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = FactorySupport.createDocumentBuilderFactory();
        factory.setNamespaceAware(namespaceAware);
        factory.setValidating(validating);
        DOMBuilder.setQuietly(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        DOMBuilder.setQuietly(factory, "http://apache.org/xml/features/disallow-doctype-decl", !allowDocTypeDeclaration);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        return documentBuilder.parse(new InputSource(reader));
    }

    private static void setQuietly(DocumentBuilderFactory factory, String feature, boolean value2) {
        try {
            factory.setFeature(feature, value2);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public Document parseText(String text) throws SAXException, IOException, ParserConfigurationException {
        return DOMBuilder.parse(new StringReader(text));
    }

    public DOMBuilder(Document document) {
        this.document = document;
    }

    public DOMBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    @Override
    protected void setParent(Object parent, Object child) {
        Node current = (Node)parent;
        Node node = (Node)child;
        current.appendChild(node);
    }

    @Override
    protected Object createNode(Object name) {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        if (name instanceof QName) {
            QName qname = (QName)name;
            return this.document.createElementNS(qname.getNamespaceURI(), qname.getQualifiedName());
        }
        return this.document.createElement(name.toString());
    }

    protected Document createDocument() {
        if (this.documentBuilder == null) {
            throw new IllegalArgumentException("No Document or DOMImplementation available so cannot create Document");
        }
        return this.documentBuilder.newDocument();
    }

    @Override
    protected Object createNode(Object name, Object value2) {
        Element element2 = (Element)this.createNode(name);
        element2.appendChild(this.document.createTextNode(value2.toString()));
        return element2;
    }

    @Override
    protected Object createNode(Object name, Map attributes, Object value2) {
        Element element2 = (Element)this.createNode(name, attributes);
        element2.appendChild(this.document.createTextNode(value2.toString()));
        return element2;
    }

    @Override
    protected Object createNode(Object name, Map attributes) {
        Element element2 = (Element)this.createNode(name);
        for (Map.Entry entry2 : attributes.entrySet()) {
            String attrName = entry2.getKey().toString();
            Object value2 = entry2.getValue();
            if ("xmlns".equals(attrName)) {
                if (value2 instanceof Map) {
                    this.appendNamespaceAttributes(element2, (Map)value2);
                    continue;
                }
                if (value2 instanceof String) {
                    this.setStringNS(element2, "", value2);
                    continue;
                }
                throw new IllegalArgumentException("The value of the xmlns attribute must be a Map of QNames to String URIs");
            }
            if (attrName.startsWith("xmlns:") && value2 instanceof String) {
                this.setStringNS(element2, attrName.substring(6), value2);
                continue;
            }
            String valueText = value2 != null ? value2.toString() : "";
            element2.setAttribute(attrName, valueText);
        }
        return element2;
    }

    protected void appendNamespaceAttributes(Element element2, Map<Object, Object> attributes) {
        for (Map.Entry<Object, Object> entry2 : attributes.entrySet()) {
            Object key2 = entry2.getKey();
            Object value2 = entry2.getValue();
            if (value2 == null) {
                throw new IllegalArgumentException("The value of key: " + key2 + " cannot be null");
            }
            if (key2 instanceof String) {
                this.setStringNS(element2, key2, value2);
                continue;
            }
            if (key2 instanceof QName) {
                QName qname = (QName)key2;
                element2.setAttributeNS(qname.getNamespaceURI(), qname.getQualifiedName(), value2.toString());
                continue;
            }
            throw new IllegalArgumentException("The key: " + key2 + " should be an instanceof of " + QName.class);
        }
    }

    private void setStringNS(Element element2, Object key2, Object value2) {
        String prefix = (String)key2;
        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "".equals(prefix) ? "xmlns" : "xmlns:" + prefix, value2.toString());
    }
}

