/*
 * Decompiled with CFR 0.152.
 */
package groovy.util.slurpersupport;

import groovy.xml.QName;
import java.util.HashMap;
import java.util.Map;

public class NamespaceAwareHashMap
extends HashMap<String, String> {
    private Map namespaceTagHints = null;

    public void setNamespaceTagHints(Map namespaceTagHints) {
        this.namespaceTagHints = namespaceTagHints;
    }

    public Map getNamespaceTagHints() {
        return this.namespaceTagHints;
    }

    @Override
    public String get(Object key2) {
        key2 = this.adjustForNamespaceIfNeeded(key2);
        return (String)super.get(key2);
    }

    @Override
    public String remove(Object key2) {
        key2 = this.adjustForNamespaceIfNeeded(key2).toString();
        return (String)super.remove(key2);
    }

    @Override
    public boolean containsKey(Object key2) {
        key2 = this.adjustForNamespaceIfNeeded(key2).toString();
        return super.containsKey(key2);
    }

    @Override
    public String put(String key2, String value2) {
        key2 = this.adjustForNamespaceIfNeeded(key2).toString();
        return super.put(key2, value2);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> o : m.entrySet()) {
            if (!(o instanceof Map.Entry)) continue;
            Map.Entry<? extends String, ? extends String> e = o;
            this.put(e.getKey(), e.getValue());
        }
    }

    private Object adjustForNamespaceIfNeeded(Object key2) {
        String keyString = key2.toString();
        if (keyString.contains("{") || this.namespaceTagHints == null || this.namespaceTagHints.isEmpty() || keyString.contains("{") || !keyString.contains(":")) {
            return key2;
        }
        int i = keyString.indexOf(":");
        return new QName(this.namespaceTagHints.get(keyString.substring(0, i)).toString(), keyString.substring(i + 1)).toString();
    }
}

