/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Closure;
import groovy.lang.EmptyRange;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Range;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.IteratorClosureAdapter;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class ObjectRange
extends AbstractList
implements Range {
    private Comparable from;
    private Comparable to;
    private int size = -1;
    private final boolean reverse;

    public ObjectRange(Comparable from2, Comparable to2) {
        if (from2 == null) {
            throw new IllegalArgumentException("Must specify a non-null value for the 'from' index in a Range");
        }
        if (to2 == null) {
            throw new IllegalArgumentException("Must specify a non-null value for the 'to' index in a Range");
        }
        try {
            this.reverse = ScriptBytecodeAdapter.compareGreaterThan(from2, to2);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Unable to create range due to incompatible types: " + from2.getClass().getSimpleName() + ".." + to2.getClass().getSimpleName() + " (possible missing brackets around range?)", cce);
        }
        if (this.reverse) {
            this.constructorHelper(to2, from2);
        } else {
            this.constructorHelper(from2, to2);
        }
    }

    public ObjectRange(Comparable from2, Comparable to2, boolean reverse2) {
        this.constructorHelper(from2, to2);
        this.reverse = reverse2;
    }

    private void constructorHelper(Comparable from2, Comparable to2) {
        if (from2 instanceof Short) {
            from2 = Integer.valueOf(((Short)from2).intValue());
        } else if (from2 instanceof Float) {
            from2 = Double.valueOf(((Float)from2).doubleValue());
        }
        if (to2 instanceof Short) {
            to2 = Integer.valueOf(((Short)to2).intValue());
        } else if (to2 instanceof Float) {
            to2 = Double.valueOf(((Float)to2).doubleValue());
        }
        if (from2 instanceof Integer && to2 instanceof Long) {
            from2 = Long.valueOf(((Integer)from2).longValue());
        } else if (to2 instanceof Integer && from2 instanceof Long) {
            to2 = Long.valueOf(((Integer)to2).longValue());
        }
        if (from2.getClass() == to2.getClass()) {
            this.from = from2;
            this.to = to2;
        } else {
            this.from = ObjectRange.normaliseStringType(from2);
            this.to = ObjectRange.normaliseStringType(to2);
        }
        if (from2 instanceof String || to2 instanceof String) {
            int i;
            String start = from2.toString();
            String end = to2.toString();
            if (start.length() > end.length()) {
                throw new IllegalArgumentException("Incompatible Strings for Range: starting String is longer than ending string");
            }
            int length2 = Math.min(start.length(), end.length());
            for (i = 0; i < length2 && start.charAt(i) == end.charAt(i); ++i) {
            }
            if (i < length2 - 1) {
                throw new IllegalArgumentException("Incompatible Strings for Range: String#next() will not reach the expected value");
            }
        }
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof ObjectRange ? this.equals((ObjectRange)that) : super.equals(that);
    }

    public boolean equals(ObjectRange that) {
        return that != null && this.reverse == that.reverse && DefaultTypeTransformation.compareEqual(this.from, that.from) && DefaultTypeTransformation.compareEqual(this.to, that.to);
    }

    public Comparable getFrom() {
        return this.from;
    }

    public Comparable getTo() {
        return this.to;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public Object get(int index) {
        Object value2;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + " should not be negative");
        }
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + " is too big for range: " + this);
        }
        if (this.reverse) {
            value2 = this.to;
            for (int i = 0; i < index; ++i) {
                value2 = this.decrement(value2);
            }
        } else {
            value2 = this.from;
            for (int i = 0; i < index; ++i) {
                value2 = this.increment(value2);
            }
        }
        return value2;
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private int index;
            private Object value;
            {
                this.value = ObjectRange.this.reverse ? ObjectRange.this.to : ObjectRange.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.index < ObjectRange.this.size();
            }

            public Object next() {
                if (this.index++ > 0) {
                    this.value = this.index > ObjectRange.this.size() ? null : (ObjectRange.this.reverse ? ObjectRange.this.decrement(this.value) : ObjectRange.this.increment(this.value));
                }
                return this.value;
            }

            @Override
            public void remove() {
                ObjectRange.this.remove(this.index);
            }
        };
    }

    @Override
    public boolean containsWithinBounds(Object value2) {
        if (value2 instanceof Comparable) {
            int result2 = this.compareTo(this.from, (Comparable)value2);
            return result2 == 0 || result2 < 0 && this.compareTo(this.to, (Comparable)value2) >= 0;
        }
        return this.contains(value2);
    }

    private int compareTo(Comparable first, Comparable second) {
        return DefaultGroovyMethods.numberAwareCompareTo(first, second);
    }

    @Override
    public int size() {
        if (this.size == -1) {
            if ((this.from instanceof Integer || this.from instanceof Long) && (this.to instanceof Integer || this.to instanceof Long)) {
                long fromNum = ((Number)((Object)this.from)).longValue();
                long toNum = ((Number)((Object)this.to)).longValue();
                this.size = (int)(toNum - fromNum + 1L);
            } else if (this.from instanceof Character && this.to instanceof Character) {
                char fromNum = ((Character)this.from).charValue();
                char toNum = ((Character)this.to).charValue();
                this.size = toNum - fromNum + 1;
            } else if (this.from instanceof BigDecimal || this.to instanceof BigDecimal || this.from instanceof BigInteger || this.to instanceof BigInteger) {
                BigDecimal fromNum = new BigDecimal("" + this.from);
                BigDecimal toNum = new BigDecimal("" + this.to);
                BigInteger sizeNum = toNum.subtract(fromNum).add(new BigDecimal(1.0)).toBigInteger();
                this.size = sizeNum.intValue();
            } else {
                this.size = 0;
                Comparable first = this.from;
                Comparable value2 = this.from;
                while (this.compareTo(this.to, value2) >= 0) {
                    value2 = (Comparable)this.increment(value2);
                    ++this.size;
                    if (this.compareTo(first, value2) < 0) continue;
                    break;
                }
            }
        }
        return this.size;
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex == toIndex) {
            return new EmptyRange(this.from);
        }
        return new ObjectRange((Comparable)this.get(fromIndex), (Comparable)this.get(--toIndex), this.reverse);
    }

    @Override
    public String toString() {
        return this.reverse ? "" + this.to + ".." + this.from : "" + this.from + ".." + this.to;
    }

    @Override
    public String inspect() {
        String toText = InvokerHelper.inspect(this.to);
        String fromText = InvokerHelper.inspect(this.from);
        return this.reverse ? "" + toText + ".." + fromText : "" + fromText + ".." + toText;
    }

    @Override
    public boolean contains(Object value2) {
        Iterator it = this.iterator();
        if (value2 == null) {
            return false;
        }
        while (it.hasNext()) {
            try {
                if (!DefaultTypeTransformation.compareEqual(value2, it.next())) continue;
                return true;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void step(int step, Closure closure) {
        if (step == 0) {
            if (this.compareTo(this.from, this.to) != 0) {
                throw new GroovyRuntimeException("Infinite loop detected due to step size of 0");
            }
            return;
        }
        if (this.reverse) {
            step = -step;
        }
        if (step > 0) {
            Comparable first = this.from;
            Comparable value2 = this.from;
            while (this.compareTo(value2, this.to) <= 0) {
                closure.call((Object)value2);
                for (int i = 0; i < step; ++i) {
                    if (this.compareTo(value2 = (Comparable)this.increment(value2), first) > 0) continue;
                    return;
                }
            }
        } else {
            step = -step;
            Comparable first = this.to;
            Comparable value3 = this.to;
            while (this.compareTo(value3, this.from) >= 0) {
                closure.call((Object)value3);
                for (int i = 0; i < step; ++i) {
                    if (this.compareTo(value3 = (Comparable)this.decrement(value3), first) < 0) continue;
                    return;
                }
            }
        }
    }

    public List step(int step) {
        IteratorClosureAdapter adapter = new IteratorClosureAdapter(this);
        this.step(step, adapter);
        return adapter.asList();
    }

    protected Object increment(Object value2) {
        return InvokerHelper.invokeMethod(value2, "next", null);
    }

    protected Object decrement(Object value2) {
        return InvokerHelper.invokeMethod(value2, "previous", null);
    }

    private static Comparable normaliseStringType(Comparable operand) {
        if (operand instanceof Character) {
            return Integer.valueOf(((Character)operand).charValue());
        }
        if (operand instanceof String) {
            String string2 = (String)((Object)operand);
            if (string2.length() == 1) {
                return Integer.valueOf(string2.charAt(0));
            }
            return string2;
        }
        return operand;
    }
}

