/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.Interceptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BenchmarkInterceptor
implements Interceptor {
    protected Map calls = new LinkedHashMap();

    public Map getCalls() {
        return this.calls;
    }

    public void reset() {
        this.calls = new HashMap();
    }

    @Override
    public Object beforeInvoke(Object object, String methodName, Object[] arguments2) {
        if (!this.calls.containsKey(methodName)) {
            this.calls.put(methodName, new LinkedList());
        }
        ((List)this.calls.get(methodName)).add(new Long(System.currentTimeMillis()));
        return null;
    }

    @Override
    public Object afterInvoke(Object object, String methodName, Object[] arguments2, Object result2) {
        ((List)this.calls.get(methodName)).add(new Long(System.currentTimeMillis()));
        return result2;
    }

    @Override
    public boolean doInvoke() {
        return true;
    }

    public List statistic() {
        LinkedList<Object[]> result2 = new LinkedList<Object[]>();
        Iterator iter2 = this.calls.keySet().iterator();
        while (iter2.hasNext()) {
            Object[] line = new Object[3];
            result2.add(line);
            line[0] = iter2.next();
            List times = (List)this.calls.get(line[0]);
            line[1] = new Integer(times.size() / 2);
            int accTime = 0;
            Iterator it = times.iterator();
            while (it.hasNext()) {
                Long start = (Long)it.next();
                Long end = (Long)it.next();
                accTime = (int)((long)accTime + (end - start));
            }
            line[2] = new Long(accTime);
        }
        return result2;
    }
}

