/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.annotations.Beta;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToInstanceMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import javax.annotation.Nullable;

@Beta
public final class MutableTypeToInstanceMap<B>
extends ForwardingMap<TypeToken<? extends B>, B>
implements TypeToInstanceMap<B> {
    private final Map<TypeToken<? extends B>, B> backingMap = Maps.newHashMap();

    @Override
    @Nullable
    public <T extends B> T getInstance(Class<T> type) {
        return this.trustedGet(TypeToken.of(type));
    }

    @Override
    @Nullable
    public <T extends B> T putInstance(Class<T> type, @Nullable T value2) {
        return this.trustedPut(TypeToken.of(type), value2);
    }

    @Override
    @Nullable
    public <T extends B> T getInstance(TypeToken<T> type) {
        return this.trustedGet(type.rejectTypeVariables());
    }

    @Override
    @Nullable
    public <T extends B> T putInstance(TypeToken<T> type, @Nullable T value2) {
        return this.trustedPut(type.rejectTypeVariables(), value2);
    }

    @Override
    public B put(TypeToken<? extends B> key2, B value2) {
        throw new UnsupportedOperationException("Please use putInstance() instead.");
    }

    @Override
    public void putAll(Map<? extends TypeToken<? extends B>, ? extends B> map2) {
        throw new UnsupportedOperationException("Please use putInstance() instead.");
    }

    @Override
    protected Map<TypeToken<? extends B>, B> delegate() {
        return this.backingMap;
    }

    @Nullable
    private <T extends B> T trustedPut(TypeToken<T> type, @Nullable T value2) {
        return (T)this.backingMap.put(type, value2);
    }

    @Nullable
    private <T extends B> T trustedGet(TypeToken<T> type) {
        return (T)this.backingMap.get(type);
    }
}

