/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.SortedSetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.Nullable;

@GwtCompatible
abstract class AbstractSortedSetMultimap<K, V>
extends AbstractSetMultimap<K, V>
implements SortedSetMultimap<K, V> {
    private static final long serialVersionUID = 430848587173315748L;

    protected AbstractSortedSetMultimap(Map<K, Collection<V>> map2) {
        super(map2);
    }

    @Override
    abstract SortedSet<V> createCollection();

    @Override
    SortedSet<V> createUnmodifiableEmptyCollection() {
        Comparator comparator = this.valueComparator();
        if (comparator == null) {
            return Collections.unmodifiableSortedSet(this.createCollection());
        }
        return ImmutableSortedSet.emptySet(this.valueComparator());
    }

    @Override
    public SortedSet<V> get(@Nullable K key2) {
        return (SortedSet)super.get((Object)key2);
    }

    @Override
    public SortedSet<V> removeAll(@Nullable Object key2) {
        return (SortedSet)super.removeAll(key2);
    }

    @Override
    public SortedSet<V> replaceValues(@Nullable K key2, Iterable<? extends V> values2) {
        return (SortedSet)super.replaceValues((Object)key2, (Iterable)values2);
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return super.asMap();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }
}

