/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions.rules;

import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.Not;
import com.bpodgursky.jbool_expressions.rules.Assign;
import com.bpodgursky.jbool_expressions.rules.CombineAnd;
import com.bpodgursky.jbool_expressions.rules.CombineOr;
import com.bpodgursky.jbool_expressions.rules.DeMorgan;
import com.bpodgursky.jbool_expressions.rules.Rule;
import com.bpodgursky.jbool_expressions.rules.SimplifyAnd;
import com.bpodgursky.jbool_expressions.rules.SimplifyNExprChildren;
import com.bpodgursky.jbool_expressions.rules.SimplifyNExpression;
import com.bpodgursky.jbool_expressions.rules.SimplifyNot;
import com.bpodgursky.jbool_expressions.rules.SimplifyOr;
import com.bpodgursky.jbool_expressions.rules.ToSOP;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RuleSet {
    public static <K> List<Rule<?, K>> simplifyRules() {
        ArrayList<Rule<?, K>> rules = Lists.newArrayList();
        rules.add(new SimplifyAnd());
        rules.add(new SimplifyOr());
        rules.add(new SimplifyNot());
        rules.add(new CombineAnd());
        rules.add(new CombineOr());
        rules.add(new SimplifyNExpression());
        rules.add(new SimplifyNExprChildren());
        return rules;
    }

    public static <K> List<Rule<?, K>> toSopRules() {
        ArrayList<Rule<?, K>> rules = Lists.newArrayList(RuleSet.simplifyRules());
        rules.add(new ToSOP());
        rules.add(new DeMorgan());
        return rules;
    }

    public static <K> List<Rule<?, K>> demorganRules() {
        ArrayList<Rule<?, K>> rules = Lists.newArrayList(RuleSet.simplifyRules());
        rules.add(new DeMorgan());
        return rules;
    }

    public static <K> Expression<K> applyAll(Expression<K> e, List<Rule<?, K>> rules) {
        Expression<K> orig = e;
        Expression<K> simplified = RuleSet.applyAllSingle(orig, rules);
        while (!orig.equals(simplified)) {
            orig = simplified;
            simplified = RuleSet.applyAllSingle(orig, rules);
        }
        return simplified;
    }

    private static <K> Expression<K> applyAllSingle(Expression<K> e, List<Rule<?, K>> rules) {
        Expression<K> tmp = e.apply(rules);
        for (Rule<?, K> r : rules) {
            tmp = r.apply(tmp);
        }
        return tmp;
    }

    public static <K> Expression<K> simplify(Expression<K> root) {
        return RuleSet.applySet(root, RuleSet.simplifyRules());
    }

    public static <K> Expression<K> toDNF(Expression<K> root) {
        return RuleSet.toSop(root);
    }

    public static <K> Expression<K> toCNF(Expression<K> root) {
        return RuleSet.toPos(root);
    }

    public static <K> Expression<K> toSop(Expression<K> root) {
        return RuleSet.applySet(root, RuleSet.toSopRules());
    }

    public static <K> Expression<K> toPos(Expression<K> root) {
        Not<K> inverse = Not.of(root);
        Expression<K> sopInv = RuleSet.toSop(inverse);
        Not<K> inverse2 = Not.of(sopInv);
        return RuleSet.applySet(inverse2, RuleSet.demorganRules());
    }

    public static <K> Expression<K> assign(Expression<K> root, Map<K, Boolean> values2) {
        ArrayList<Rule<?, K>> rules = Lists.newArrayList(RuleSet.simplifyRules());
        rules.add(new Assign<K>(values2));
        return RuleSet.applySet(root, rules);
    }

    public static <K> Expression<K> applySet(Expression<K> root, List<Rule<?, K>> allRules) {
        return RuleSet.applyAll(root, allRules);
    }
}

