/*
 * Decompiled with CFR 0.152.
 */
package com.bpodgursky.jbool_expressions;

import com.bpodgursky.jbool_expressions.ExprUtil;
import com.bpodgursky.jbool_expressions.Expression;
import com.bpodgursky.jbool_expressions.rules.Rule;
import com.bpodgursky.jbool_expressions.rules.RuleSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class NExpression<K>
extends Expression<K> {
    public final Expression<K>[] expressions;

    protected NExpression(List<Expression<K>> expressions) {
        if (expressions.isEmpty()) {
            throw new IllegalArgumentException("Arguments length 0!");
        }
        this.expressions = expressions.toArray(ExprUtil.expr(0));
    }

    protected NExpression(Expression<K>[] expressions) {
        if (expressions.length == 0) {
            throw new IllegalArgumentException("Arguments length 0!");
        }
        this.expressions = expressions;
        Arrays.sort(this.expressions);
    }

    @Override
    public Expression<K> apply(List<Rule<?, K>> rules) {
        ArrayList<Expression<K>> childCopy = Lists.newArrayList();
        for (Expression<K> expr : this.expressions) {
            childCopy.add(RuleSet.applyAll(expr, rules));
        }
        return this.createInternal(childCopy);
    }

    public List<Expression<K>> getChildren() {
        return ExprUtil.list(this.expressions);
    }

    protected abstract Expression<K> createInternal(List<Expression<K>> var1);
}

