/*
 * Decompiled with CFR 0.152.
 */
package beaver;

public class Symbol
implements Cloneable {
    private static final int COLUMN_FIELD_BITS = 12;
    private static final int COLUMN_FIELD_MASK = 4095;
    public Object value;
    protected short id;
    protected int start;
    protected int end;

    public static int makePosition(int line, int column) {
        return line << 12 | column;
    }

    public static int getLine(int position) {
        return position >>> 12;
    }

    public static int getColumn(int position) {
        return position & 0xFFF;
    }

    public Symbol(short id) {
        this.id = id;
        this.value = null;
    }

    public Symbol(short id, Object value2) {
        this.id = id;
        this.value = value2;
    }

    public Symbol(short id, int start, int end) {
        this.id = id;
        this.value = null;
        this.start = start;
        this.end = end;
    }

    public Symbol(short id, int left, int right, Object value2) {
        this.id = id;
        this.value = value2;
        this.start = left;
        this.end = right;
    }

    public Symbol(short id, int start_line, int start_column, int length2) {
        this.id = id;
        this.value = null;
        this.start = Symbol.makePosition(start_line, start_column);
        this.end = Symbol.makePosition(start_line, start_column + length2 - 1);
    }

    public Symbol(short id, int start_line, int start_column, int length2, Object value2) {
        this.id = id;
        this.value = value2;
        this.start = Symbol.makePosition(start_line, start_column);
        this.end = Symbol.makePosition(start_line, start_column + length2 - 1);
    }

    public Symbol(Object value2) {
        this.value = value2;
    }

    protected Symbol() {
        this.value = this;
    }

    public short getId() {
        return this.id;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public Symbol clone() throws CloneNotSupportedException {
        Symbol copy = (Symbol)super.clone();
        copy.value = copy;
        return copy;
    }
}

