---
title: "PowerShell"
draft: false
description: "Reference material for the PowerShell exploiter"
pre: "<i class='fas fa-terminal'></i> "
---
{{< table_of_contents >}}

## Supported operating systems

| Operating system | Attack from                 | Target                      |
| :--------------- | :-------------------------- | :-------------------------- |
| Linux            | {{< os-icon-partial >}}     | {{< os-icon-unsupported >}} |
| Windows          | {{< os-icon-supported >}}   | {{< os-icon-supported >}}   |

On Linux attackers, the set of credentials that can be used to authenticate
with a remote host is limited. See [Credentials used for
brute-forcing](#credentials-used-for-brute-forcing) for specific details.

## Configuration

<!--
This documentation was autogenerated by passing the plugin's config-schema.json
through https://github.com/adobe/jsonschema2md. It was then modified by hand to
remove extraneous information.
-->

| Property                                          | Type     | Required | Nullable       |
| :------------------------------------------------ | :------- | :------- | :------------- |
| [winrm\_connect\_timeout](#winrm_connect_timeout) | `number` | Optional | cannot be null |

### winrm\_connect\_timeout

The maximum time (in seconds) to wait for a response on a WinRM connection.

`winrm_connect_timeout`

* is optional

* Type: `number`

* cannot be null

#### winrm\_connect\_timeout Constraints

**maximum**: the value of this number must smaller than or equal to: `100`

**minimum (exclusive)**: the value of this number must be greater than: `0`

#### winrm\_connect\_timeout Default Value

The default value is:

```json
3
```

## Credentials used for brute-forcing

When attempting to authenticate with a target host, different combinations of
credentials are attempted in the following order:

1. Cached username and password (Windows attacker only)
1. Brute force usernames with blank passwords
1. Brute force usernames with cached password (Windows attacker only)
1. Brute force usernames and passwords
1. Brute force usernames and LM hashes
1. Brute force usernames and NT hashes
