﻿using System;
using System.Net.Sockets;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Reflection;
using AutoSecTools.Components;

namespace HTTPBog
{
    public static class UI
    {
        private static string _version = Assembly.GetExecutingAssembly().GetName().Version.ToString();

        public static void Pause()
        {
            Console.WriteLine("Press any key to continue...");
            Console.ReadKey();
        }

        public static void DisplayAppInfo()
        {
            Console.WriteLine(@"HTTP Bog {0}
John Leitch http://www.autosectools.com/", _version);
        }

        public static void DisplayStats(SlowHttpClient Client)
        {
            var template =
@"Url:      {0}
Sockets:  {1}
Bytes:    {2}";

            while (true)
            {
                Thread.Sleep(2000);

                Console.Clear();
                UI.DisplayAppInfo();
                Console.WriteLine();
                lock (Client.Clients)
                    Console.WriteLine(template, Client.Url,
                        Client.Clients.Count(x => x.Connected),
                        Client.BytesRead);
            }
        }

        public static void DisplayInstructions()
        {
            Console.WriteLine(
@"
================================
Required Parameters
================================

-Url {Target}               The URL of the target


================================
Optional Parameters
================================

-Timeout {Timeout}          The TCP send/receive timeout in milliseconds. 
                            Default: 16000

-ClientCount {Count}        The maximum number of active TCP connections.
                            Default: 16384

-CreateSleep {Duration}     The sleep time in milliseconds between creating 
                            clients.
                            Default: 250

-CreateCount {Count}        The number of clients to create after sleeping.
                            Default: 256

-ReadSleepMin {Duration}    The minimum amount of sleep time in milliseconds 
                            between reading from clients.
                            Default: 0

-ReadSleepMax {Duration}    The minimum amount of sleep time in milliseconds 
                            between reading from clients.
                            Default: 10000

-Silent                     Runs application without showing status updates.


================================
Examples
================================

httpbog -url http://testserver/wordpress/

httpbog -url http://testserver/file.php -timeout 8000
"
                );

            Pause();
        }       

        public static void DisplayException(Exception Ex)
        {
            Console.WriteLine("\r\n" + Ex.Message + "\r\n");
            UI.Pause();            
        }
    }
}
