﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using AutoSecTools.Components;

namespace HTTPBog
{
    
    class Program
    {
        static void HandleException(Exception Ex)
        {
            UI.DisplayException(Ex);
            Environment.Exit(1);
        }

        static void Main(string[] args)
        {
            UI.DisplayAppInfo();

            if (args.Length == 0)
            {
                UI.DisplayInstructions();
                Environment.Exit(0);
            }

            SlowHttpClient client = new SlowHttpClient();

            try
            {
                var reader = new CommandLineArgumentSetter(args);
                reader.SetProperties(client);

                var errors = client.ValidateClient();

                if (errors.Any())
                    HandleException(new Exception(errors.Aggregate("\r\n")));
            }
            catch (ArgumentException ex)
            {
                HandleException(ex);
            }
            catch (UriFormatException ex)
            {
                HandleException(ex);
            }

            if (!client.Silent)
                ThreadPool.QueueUserWorkItem(x => UI.DisplayStats(client));

            client.SlowRead();

            new ManualResetEvent(false).WaitOne();
        }
    }
}
