# HikPwn
HikPwn, a simple scanner for Hikvision devices with basic vulnerability scanning capabilities written in Python 3.8.
This project was born out of curiosity while I was capturing and watching network traffic generated by some Hikvision's software and devices.

### Setup instructions:
```
git clone https://github.com/4n4nk3/HikPwn.git
cd HikPwn
pip install -r requirements.txt
```

### Tested on:
 - [x] Python 3.8 on Linux 4.19 x86_64

### Functions and characteristics:
 - [x] Passive discovery of Hikvision devices.
 - [x] Active discovery and enumeration of Hikvision devices via UDP UPNP probing.
 - [x] Detection and exploitation capabilities for ICSA-17-124-01 leading to admin level access.
 - [x] Save enumerated data to './log.txt'.

 > Work in progress... stay tuned!
 
#### TODO:

- [ ] Add option to skip discovery and only scan a specified IP for ICSA-17-124-01.
- [ ] Testing with more devices.
- [ ] Add detection and exploitation capability for CVE-2021-36260.

### Help:
```
usage: hikpwn.py [-h] --interface INTERFACE --address ADDRESS [--active]  [--ICSA_17_124_01]

HikPwn, a simple scanner for Hikvision devices with basic vulnerability scanning capabilities written in Python 3.8. by Ananke: https://github.com/4n4nk3.

optional arguments:
  -h, --help            show this help message and exit
  --interface INTERFACE the network interface to use
  --address ADDRESS     the ip address of the selected network interface
  --active              enable "active" discovery
  --ICSA_17_124_01      enable ICSA-17-124-01 detection on discovered devices
```

### Censored preview:
```
Using eth0 as network interface and XXX.XXX.XXX.XXX as its IP address...

[*] Started 30 seconds of both passive and active discovery...

================================================================================
[*] Total detected devices: 1

	XXX.XXX.XXX.XX

================================================================================
[*] Active discovery's results:

DEVICE #1:
	LABEL                     DATA      
	--------------------------------------------------
	Serial Number             xxxxxxxxxxxxxxxxxxxxx
	Description               DS-2DE4220IW-D
	MAC                       XX:XX:XX:XX:XX:XX
	IP                        XXX.XXX.XXX.XX
	DHCP in use               false     
	Software Version          V5.4.3build 160810
	DSP Version               V7.3 build 160801
	Boot Time                 2019-03-01 00:05:33
	Activation Status         true      
	Password Reset Ability    true      


================================================================================
[*] Passive discovery's results:

DEVICE #1:
	Detected a device with ip address XXX.XXX.XXX.XX and MAC address XX:XX:XX:XX:XX:XX.


================================================================================
[*] Starting scan for ICSA-17-124-01...

Checking if XXX.XXX.XXX.XX is vulnerable to ICSA-17-124-01 and if we can get a list of valid users present on the device...
XXX.XXX.XXX.XX is vulnerable to ICSA_17_124_01. Recovered user list:
    user_id                   1
    user_name                 admin
    priority                  high
    user_level                Administrator

Do you want to exploit the vulnerability and try to change admin's password? (y/n)
    >>> y

Enter a password composed by numbers and letters (8-12 characters):
    >>> 

Password change successful.
```

**_This project is for educational purposes only. Don't use it for illegal activities. I don't support nor condone illegal or unethical actions and I can't be held responsible for possible misuse of this software._**
