/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.CompletionXMLParser;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultCompletionProvider
extends AbstractCompletionProvider {
    protected Segment seg;
    private String lastCompletionsAtText;
    private List lastParameterizedCompletionsAt;

    public DefaultCompletionProvider() {
        this.init();
    }

    public DefaultCompletionProvider(String[] stringArray) {
        this.init();
        this.addWordCompletions(stringArray);
    }

    public String getAlreadyEnteredText(JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        int n = jTextComponent.getCaretPosition();
        Element element = document.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        int n4 = n - n3;
        try {
            document.getText(n3, n4, this.seg);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return "";
        }
        int n5 = this.seg.offset + n4;
        for (n3 = n5 - 1; n3 >= this.seg.offset && this.isValidChar(this.seg.array[n3]); --n3) {
        }
        return (n4 = n5 - ++n3) == 0 ? "" : new String(this.seg.array, n3, n4);
    }

    public List getCompletionsAt(JTextComponent jTextComponent, Point point) {
        int n = jTextComponent.viewToModel(point);
        if (n < 0 || n >= jTextComponent.getDocument().getLength()) {
            this.lastCompletionsAtText = null;
            this.lastParameterizedCompletionsAt = null;
            return null;
        }
        Segment segment = new Segment();
        Document document = jTextComponent.getDocument();
        Element element = document.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        int n4 = element2.getEndOffset() - 1;
        try {
            int n5;
            int n6;
            document.getText(n3, n4 - n3, segment);
            for (n6 = segment.offset + (n - n3) - 1; n6 >= segment.offset && this.isValidChar(segment.array[n6]); --n6) {
            }
            for (n5 = segment.offset + (n - n3); n5 < segment.offset + segment.count && this.isValidChar(segment.array[n5]); ++n5) {
            }
            int n7 = n5 - n6 - 1;
            if (n7 <= 0) {
                this.lastParameterizedCompletionsAt = null;
                return null;
            }
            String string = new String(segment.array, n6 + 1, n7);
            if (string.equals(this.lastCompletionsAtText)) {
                return this.lastParameterizedCompletionsAt;
            }
            List list = this.getCompletionByInputText(string);
            this.lastCompletionsAtText = string;
            this.lastParameterizedCompletionsAt = list;
            return this.lastParameterizedCompletionsAt;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            this.lastCompletionsAtText = null;
            this.lastParameterizedCompletionsAt = null;
            return null;
        }
    }

    public List getParameterizedCompletions(JTextComponent jTextComponent) {
        int n;
        ArrayList arrayList = null;
        char c = this.getParameterListStart();
        if (c == '\u0000') {
            return arrayList;
        }
        int n2 = jTextComponent.getCaretPosition();
        Segment segment = new Segment();
        Document document = jTextComponent.getDocument();
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n = element.getElementIndex(n2));
        int n3 = element2.getStartOffset();
        int n4 = n2 - n3 - 1;
        if (n4 <= 0) {
            return arrayList;
        }
        try {
            document.getText(n3, n4, segment);
            for (n3 = segment.offset + n4 - 1; n3 >= segment.offset && Character.isWhitespace(segment.array[n3]); --n3) {
            }
            int n5 = n3;
            while (n3 >= segment.offset && this.isValidChar(segment.array[n3])) {
                --n3;
            }
            String string = new String(segment.array, n3 + 1, n5 - n3);
            List list = this.getCompletionByInputText(string);
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof ParameterizedCompletion)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList(1);
                    }
                    arrayList.add(e);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return arrayList;
    }

    protected void init() {
        this.completions = new ArrayList();
        this.seg = new Segment();
    }

    protected boolean isValidChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromXML(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            this.loadFromXML(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
        }
    }

    public void loadFromXML(InputStream inputStream) throws IOException {
        this.loadFromXML(inputStream, null);
    }

    public void loadFromXML(InputStream inputStream, ClassLoader classLoader) throws IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        CompletionXMLParser completionXMLParser = new CompletionXMLParser(this, classLoader);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse((InputStream)bufferedInputStream, (DefaultHandler)completionXMLParser);
            List list = completionXMLParser.getCompletions();
            this.addCompletions(list);
            char c = completionXMLParser.getParamStartChar();
            if (c != '\u0000') {
                char c2 = completionXMLParser.getParamEndChar();
                String string = completionXMLParser.getParamSeparator();
                if (c2 != '\u0000' && string != null && string.length() > 0) {
                    this.setParameterizedCompletionParams(c, string, c2);
                }
            }
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.toString());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.toString());
        }
        finally {
            bufferedInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromXML(String string) throws IOException {
        Object object;
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            object = new File(string);
            if (((File)object).isFile()) {
                inputStream = new FileInputStream((File)object);
            } else {
                throw new IOException("No such resource: " + string);
            }
        }
        object = new BufferedInputStream(inputStream);
        try {
            this.loadFromXML((InputStream)object);
        }
        finally {
            ((BufferedInputStream)object).close();
        }
    }
}

