/*
 * Decompiled with CFR 0.152.
 */
package halcyon.ide;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class ConfigurationManager {
    String os;
    String home;
    String appfolder = "HalcyonIDE";
    String filename = "HalcyonIDE.ini";
    String configfile;
    String scan_type;
    String script_arg;
    String script_argfile;
    String pkt_trace;
    String debug;
    String verbose;
    String nmap_path;
    String script_path;
    String lib_path;
    Properties prop = new Properties();

    public ConfigurationManager() {
        this.os = System.getProperty("os.name");
        this.home = System.getProperty("user.home");
    }

    public void init() {
        this.scan_type = "tcp";
        this.script_arg = "";
        this.script_argfile = "";
        this.pkt_trace = "False";
        this.debug = "True";
        this.verbose = "False";
        this.nmap_path = "";
        this.script_path = "";
        this.lib_path = "";
        this.configfile = this.getConfigFilePath();
        this.SetNmapEnv();
        if (this.configfile.equals(null) && this.configfile.isEmpty()) {
            this.CreateConfiguration();
        } else {
            this.LoadConfiguration();
        }
    }

    public String validateConfigPath(String base, String appdir, String file) {
        String absolutepath = null;
        File f = new File(base + File.separator + appdir + File.separator + file);
        File af = new File(base + File.separator + appdir);
        try {
            if (af.exists()) {
                if (f.exists()) {
                    absolutepath = f.getAbsolutePath();
                } else {
                    f.createNewFile();
                    absolutepath = f.getAbsolutePath();
                }
            } else {
                af.mkdir();
                f.createNewFile();
                this.CreateConfiguration();
                absolutepath = f.getAbsolutePath();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in validateConfigpath");
            e.printStackTrace();
        }
        return absolutepath;
    }

    public String getConfigFilePath() {
        String configfilepath = "";
        if (this.os.contains("Mac OS X")) {
            configfilepath = this.validateConfigPath(System.getProperty("user.home"), this.appfolder, this.filename);
        } else if (this.os.contains("Windows")) {
            configfilepath = this.validateConfigPath(System.getenv("APPDATA"), this.appfolder, this.filename);
        } else if (this.os.contains("Linux")) {
            configfilepath = this.validateConfigPath(System.getProperty("user.home"), this.appfolder, this.filename);
        }
        return configfilepath;
    }

    public void LoadConfiguration() {
        try {
            if (this.configfile != null) {
                FileInputStream in = new FileInputStream(this.configfile);
                this.prop.load(in);
                if (this.prop.getProperty("version") == null) {
                    this.CreateConfiguration();
                    this.LoadConfiguration();
                } else {
                    this.scan_type = this.prop.getProperty("scan_type");
                    this.script_arg = this.prop.getProperty("script_arg");
                    this.script_argfile = this.prop.getProperty("script_argfile");
                    this.pkt_trace = this.prop.getProperty("pkt_trace");
                    this.debug = this.prop.getProperty("debug");
                    this.verbose = this.prop.getProperty("verbose");
                    this.nmap_path = this.prop.getProperty("nmap_path");
                    this.script_path = this.prop.getProperty("script_path");
                    this.lib_path = this.prop.getProperty("lib_path");
                }
            } else {
                this.CreateConfiguration();
                this.LoadConfiguration();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void CreateConfiguration() {
        try {
            if (this.configfile != null) {
                FileOutputStream out = new FileOutputStream(this.configfile);
                this.prop.setProperty("version", "2.0.2");
                this.prop.setProperty("scan_type", this.scan_type);
                this.prop.setProperty("script_arg", this.script_arg);
                this.prop.setProperty("script_argfile", this.script_argfile);
                this.prop.setProperty("pkt_trace", this.pkt_trace);
                this.prop.setProperty("debug", this.debug);
                this.prop.setProperty("verbose", this.verbose);
                this.prop.setProperty("nmap_path", this.nmap_path);
                this.prop.setProperty("script_path", this.script_path);
                this.prop.setProperty("lib_path", this.lib_path);
                this.prop.store(out, "Halcyon IDE - https://halcyon-ide.org");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void UpdateConfiguration(String key, Object value) {
    }

    public void SaveConfiguration(String type, String arg, String argfile, String pt, String d, String v, String nmap, String nscript, String nlib) {
        try {
            this.configfile = this.getConfigFilePath();
            if (this.configfile != null) {
                FileOutputStream out = new FileOutputStream(this.configfile);
                this.prop.setProperty("version", "2.0.2");
                this.prop.setProperty("scan_type", type);
                this.prop.setProperty("script_arg", arg);
                this.prop.setProperty("script_argfile", argfile);
                this.prop.setProperty("pkt_trace", pt);
                this.prop.setProperty("debug", d);
                this.prop.setProperty("verbose", v);
                this.prop.setProperty("nmap_path", nmap);
                this.prop.setProperty("script_path", nscript);
                this.prop.setProperty("lib_path", nlib);
                this.prop.store(out, "Halcyon IDE - https://halcyon-ide.org");
            } else {
                System.out.println("Error in saving configuration");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void SetNmapEnv() {
        String npath = "";
        String nse = "";
        String lib = "";
        boolean flag = false;
        try {
            String os = System.getProperty("os.name");
            if (os.contains("Mac OS X")) {
                npath = "/usr/local/bin/nmap";
                nse = "/usr/local/share/nmap/scripts/";
                lib = "/usr/local/share/nmap/nselib/";
                flag = true;
            } else if (os.contains("Windows")) {
                String[] paths;
                String p = null;
                String path = System.getenv("PATH");
                for (String path1 : paths = path.split(";")) {
                    if (!path1.contains("Nmap") && !path1.contains("nmap")) continue;
                    npath = path1 + "\\nmap";
                    nse = path1 + "\\scripts\\";
                    lib = path1 + "\\nselib\\";
                    flag = true;
                }
                File f = new File(System.getenv("ProgramFiles") + "\\Nmap");
                if (new File(System.getenv("ProgramFiles") + "\\Nmap").exists()) {
                    p = System.getenv("ProgramFiles");
                } else if (new File(System.getenv("ProgramFiles(X86)") + "\\Nmap").exists()) {
                    p = System.getenv("ProgramFiles(X86)");
                }
                if (!p.isEmpty()) {
                    npath = p + "\\Nmap\\nmap.exe";
                    nse = p + "\\Nmap\\scripts\\";
                    lib = p + "\\Nmap\\nselib\\";
                    flag = true;
                }
            } else if (os.contains("Linux")) {
                npath = "/usr/bin/nmap";
                nse = "/usr/share/nmap/scripts/";
                lib = "/usr/share/nmap/nselib/";
                flag = true;
            }
            if (flag) {
                File isNPATH = new File(npath);
                File isNSE = new File(nse);
                File isLIB = new File(lib);
                if (isNPATH.exists() && isNSE.exists() && isLIB.exists()) {
                    this.nmap_path = npath;
                    this.script_path = nse;
                    this.lib_path = lib;
                }
            }
        }
        catch (NullPointerException e) {
            String string = "<html>Unable to find the nmap location.<br>Please configure it manually.</html>";
        }
    }
}

