#!/usr/bin/env python
# -*- coding: utf-8 -*-

__license__= """
GoLismero 2.0 - The web knife - Copyright (C) 2011-2014

Golismero project site: https://github.com/golismero
Golismero project mail: contact@golismero-project.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

__all__ = ["DebuggingEnabled"]

from .. import WebVulnerability

class DebuggingEnabled(WebVulnerability):
    """
    Debugging Enabled.

    Debugging is enabled at a web server.
    This may help an adversary to gather information prior to an attack.

    Disable debugging in production, it should only be enabled on testing
    and/or development environments.
    """

    DEFAULTS = WebVulnerability.DEFAULTS.copy()
    DEFAULTS["level"]      = "informational"
    DEFAULTS["cwe"]        = "CWE-215"
    DEFAULTS["cvss_base"]  = "2.4"
    DEFAULTS["references"] = (
        "https://www.owasp.org/index.php/Information_Leakage",
    )
