/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector.xstream;

import gadgetinspector.SerializableDecider;
import gadgetinspector.data.ClassReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CustomXstreamSerializableDecider
implements SerializableDecider {
    private final Map<ClassReference.Handle, Boolean> serializableMap = new HashMap<ClassReference.Handle, Boolean>();
    private final Map<ClassReference.Handle, ClassReference> classMap;
    private final Map<ClassReference.Handle, Set<ClassReference.Handle>> inheritanceMap;

    public CustomXstreamSerializableDecider(Map<ClassReference.Handle, ClassReference> classMap, Map<ClassReference.Handle, Set<ClassReference.Handle>> inheritanceMap) {
        this.classMap = classMap;
        this.inheritanceMap = inheritanceMap;
    }

    @Override
    public Boolean apply(ClassReference.Handle handle) {
        ArrayList<ClassReference.Handle> circularRefList = new ArrayList<ClassReference.Handle>();
        Boolean result = this.isSerializable(handle, circularRefList);
        if (circularRefList.size() != 0) {
            throw new IllegalStateException();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSerializable(ClassReference.Handle clazz, List<ClassReference.Handle> circularRefList) {
        Boolean serializable = this.serializableMap.get(clazz);
        if (serializable != null) {
            return serializable;
        }
        if (circularRefList.contains(clazz)) {
            this.serializableMap.put(clazz, Boolean.FALSE);
            return false;
        }
        if (clazz.getName().equals("java/lang/String")) {
            this.serializableMap.put(clazz, Boolean.TRUE);
            return true;
        }
        if (clazz.getName().charAt(0) == '[' || clazz.getName().equals("java/lang/Class")) {
            this.serializableMap.put(clazz, Boolean.FALSE);
            return false;
        }
        ClassReference classReference = this.classMap.get(clazz);
        if (classReference == null) {
            this.serializableMap.put(clazz, Boolean.TRUE);
            return true;
        }
        circularRefList.add(clazz);
        try {
            for (ClassReference.Member member : classReference.getMembers()) {
                if (member.getName().contains("$")) {
                    this.serializableMap.put(clazz, Boolean.FALSE);
                    boolean bl = false;
                    return bl;
                }
                if (this.isSerializable(member.getType(), circularRefList)) continue;
                this.serializableMap.put(clazz, Boolean.FALSE);
                boolean bl = false;
                return bl;
            }
            for (ClassReference.Handle superClass : this.inheritanceMap.get(clazz)) {
                if (this.isSerializable(superClass, circularRefList)) continue;
                this.serializableMap.put(clazz, Boolean.FALSE);
                int n = 0;
                return n != 0;
            }
        }
        finally {
            circularRefList.remove(circularRefList.size() - 1);
        }
        this.serializableMap.put(clazz, Boolean.TRUE);
        return true;
    }
}

