/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector.javaserial;

import gadgetinspector.SourceDiscovery;
import gadgetinspector.data.ClassReference;
import gadgetinspector.data.InheritanceMap;
import gadgetinspector.data.MethodReference;
import gadgetinspector.data.Source;
import gadgetinspector.javaserial.SimpleSerializableDecider;
import java.util.Map;
import org.objectweb.asm.Type;

public class SimpleSourceDiscovery
extends SourceDiscovery {
    @Override
    public void discover(Map<ClassReference.Handle, ClassReference> classMap, Map<MethodReference.Handle, MethodReference> methodMap, InheritanceMap inheritanceMap) {
        SimpleSerializableDecider serializableDecider = new SimpleSerializableDecider(inheritanceMap);
        for (MethodReference.Handle method : methodMap.keySet()) {
            if (!Boolean.TRUE.equals(serializableDecider.apply(method.getClassReference())) || !method.getName().equals("finalize") || !method.getDesc().equals("()V")) continue;
            this.addDiscoveredSource(new Source(method, 0));
        }
        for (MethodReference.Handle method : methodMap.keySet()) {
            if (!Boolean.TRUE.equals(serializableDecider.apply(method.getClassReference())) || !method.getName().equals("readObject") || !method.getDesc().equals("(Ljava/io/ObjectInputStream;)V")) continue;
            this.addDiscoveredSource(new Source(method, 1));
        }
        for (ClassReference.Handle clazz : classMap.keySet()) {
            if (!Boolean.TRUE.equals(serializableDecider.apply(clazz)) || !inheritanceMap.isSubclassOf(clazz, new ClassReference.Handle("java/lang/reflect/InvocationHandler"))) continue;
            MethodReference.Handle method = new MethodReference.Handle(clazz, "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;");
            this.addDiscoveredSource(new Source(method, 0));
        }
        for (MethodReference.Handle method : methodMap.keySet()) {
            if (!Boolean.TRUE.equals(serializableDecider.apply(method.getClassReference()))) continue;
            if (method.getName().equals("hashCode") && method.getDesc().equals("()I")) {
                this.addDiscoveredSource(new Source(method, 0));
            }
            if (!method.getName().equals("equals") || !method.getDesc().equals("(Ljava/lang/Object;)Z")) continue;
            this.addDiscoveredSource(new Source(method, 0));
            this.addDiscoveredSource(new Source(method, 1));
        }
        for (MethodReference.Handle method : methodMap.keySet()) {
            if (!Boolean.TRUE.equals(serializableDecider.apply(method.getClassReference())) || !inheritanceMap.isSubclassOf(method.getClassReference(), new ClassReference.Handle("groovy/lang/Closure")) || !method.getName().equals("call") && !method.getName().equals("doCall")) continue;
            this.addDiscoveredSource(new Source(method, 0));
            Type[] methodArgs = Type.getArgumentTypes(method.getDesc());
            for (int i = 0; i < methodArgs.length; ++i) {
                this.addDiscoveredSource(new Source(method, i + 1));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        SimpleSourceDiscovery sourceDiscovery = new SimpleSourceDiscovery();
        sourceDiscovery.discover();
        sourceDiscovery.save();
    }
}

