/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector.jackson;

import gadgetinspector.SerializableDecider;
import gadgetinspector.data.ClassReference;
import gadgetinspector.data.MethodReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JacksonSerializableDecider
implements SerializableDecider {
    private final Map<ClassReference.Handle, Boolean> cache = new HashMap<ClassReference.Handle, Boolean>();
    private final Map<ClassReference.Handle, Set<MethodReference.Handle>> methodsByClassMap = new HashMap<ClassReference.Handle, Set<MethodReference.Handle>>();

    public JacksonSerializableDecider(Map<MethodReference.Handle, MethodReference> methodMap) {
        for (MethodReference.Handle method : methodMap.keySet()) {
            Set<MethodReference.Handle> classMethods = this.methodsByClassMap.get(method.getClassReference());
            if (classMethods == null) {
                classMethods = new HashSet<MethodReference.Handle>();
                this.methodsByClassMap.put(method.getClassReference(), classMethods);
            }
            classMethods.add(method);
        }
    }

    @Override
    public Boolean apply(ClassReference.Handle handle) {
        Boolean cached = this.cache.get(handle);
        if (cached != null) {
            return cached;
        }
        Set<MethodReference.Handle> classMethods = this.methodsByClassMap.get(handle);
        if (classMethods != null) {
            for (MethodReference.Handle method : classMethods) {
                if (!method.getName().equals("<init>") || !method.getDesc().equals("()V")) continue;
                this.cache.put(handle, Boolean.TRUE);
                return Boolean.TRUE;
            }
        }
        this.cache.put(handle, Boolean.FALSE);
        return Boolean.FALSE;
    }
}

