/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector.data;

import gadgetinspector.data.ClassReference;
import gadgetinspector.data.DataFactory;

public class MethodReference {
    private final ClassReference.Handle classReference;
    private final String name;
    private final String desc;
    private final boolean isStatic;

    public MethodReference(ClassReference.Handle classReference, String name, String desc, boolean isStatic) {
        this.classReference = classReference;
        this.name = name;
        this.desc = desc;
        this.isStatic = isStatic;
    }

    public ClassReference.Handle getClassReference() {
        return this.classReference;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public Handle getHandle() {
        return new Handle(this.classReference, this.name, this.desc);
    }

    public static class Handle {
        private final ClassReference.Handle classReference;
        private final String name;
        private final String desc;

        public Handle(ClassReference.Handle classReference, String name, String desc) {
            this.classReference = classReference;
            this.name = name;
            this.desc = desc;
        }

        public ClassReference.Handle getClassReference() {
            return this.classReference;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Handle handle = (Handle)o;
            if (this.classReference != null ? !this.classReference.equals(handle.classReference) : handle.classReference != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(handle.name) : handle.name != null) {
                return false;
            }
            return this.desc != null ? this.desc.equals(handle.desc) : handle.desc == null;
        }

        public int hashCode() {
            int result = this.classReference != null ? this.classReference.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
            return result;
        }
    }

    public static class Factory
    implements DataFactory<MethodReference> {
        @Override
        public MethodReference parse(String[] fields) {
            return new MethodReference(new ClassReference.Handle(fields[0]), fields[1], fields[2], Boolean.parseBoolean(fields[3]));
        }

        @Override
        public String[] serialize(MethodReference obj) {
            return new String[]{obj.classReference.getName(), obj.name, obj.desc, Boolean.toString(obj.isStatic)};
        }
    }
}

