/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector.data;

import gadgetinspector.data.ClassReference;
import gadgetinspector.data.DataFactory;
import gadgetinspector.data.MethodReference;

public class GraphCall {
    private final MethodReference.Handle callerMethod;
    private final MethodReference.Handle targetMethod;
    private final int callerArgIndex;
    private final String callerArgPath;
    private final int targetArgIndex;

    public GraphCall(MethodReference.Handle callerMethod, MethodReference.Handle targetMethod, int callerArgIndex, String callerArgPath, int targetArgIndex) {
        this.callerMethod = callerMethod;
        this.targetMethod = targetMethod;
        this.callerArgIndex = callerArgIndex;
        this.callerArgPath = callerArgPath;
        this.targetArgIndex = targetArgIndex;
    }

    public MethodReference.Handle getCallerMethod() {
        return this.callerMethod;
    }

    public MethodReference.Handle getTargetMethod() {
        return this.targetMethod;
    }

    public int getCallerArgIndex() {
        return this.callerArgIndex;
    }

    public String getCallerArgPath() {
        return this.callerArgPath;
    }

    public int getTargetArgIndex() {
        return this.targetArgIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphCall graphCall = (GraphCall)o;
        if (this.callerArgIndex != graphCall.callerArgIndex) {
            return false;
        }
        if (this.targetArgIndex != graphCall.targetArgIndex) {
            return false;
        }
        if (this.callerMethod != null ? !this.callerMethod.equals(graphCall.callerMethod) : graphCall.callerMethod != null) {
            return false;
        }
        if (this.targetMethod != null ? !this.targetMethod.equals(graphCall.targetMethod) : graphCall.targetMethod != null) {
            return false;
        }
        return this.callerArgPath != null ? this.callerArgPath.equals(graphCall.callerArgPath) : graphCall.callerArgPath == null;
    }

    public int hashCode() {
        int result = this.callerMethod != null ? this.callerMethod.hashCode() : 0;
        result = 31 * result + (this.targetMethod != null ? this.targetMethod.hashCode() : 0);
        result = 31 * result + this.callerArgIndex;
        result = 31 * result + (this.callerArgPath != null ? this.callerArgPath.hashCode() : 0);
        result = 31 * result + this.targetArgIndex;
        return result;
    }

    public static class Factory
    implements DataFactory<GraphCall> {
        @Override
        public GraphCall parse(String[] fields) {
            return new GraphCall(new MethodReference.Handle(new ClassReference.Handle(fields[0]), fields[1], fields[2]), new MethodReference.Handle(new ClassReference.Handle(fields[3]), fields[4], fields[5]), Integer.parseInt(fields[6]), fields[7], Integer.parseInt(fields[8]));
        }

        @Override
        public String[] serialize(GraphCall obj) {
            return new String[]{obj.callerMethod.getClassReference().getName(), obj.callerMethod.getName(), obj.callerMethod.getDesc(), obj.targetMethod.getClassReference().getName(), obj.targetMethod.getName(), obj.targetMethod.getDesc(), Integer.toString(obj.callerArgIndex), obj.callerArgPath, Integer.toString(obj.targetArgIndex)};
        }
    }
}

