/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector.data;

import com.google.common.io.Files;
import gadgetinspector.data.ClassReference;
import gadgetinspector.data.DataFactory;
import gadgetinspector.data.MethodReference;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataLoader {
    public static <T> List<T> loadData(Path filePath, DataFactory<T> factory) throws IOException {
        List<String> lines = Files.readLines(filePath.toFile(), StandardCharsets.UTF_8);
        ArrayList<T> values = new ArrayList<T>(lines.size());
        for (String line : lines) {
            values.add(factory.parse(line.split("\t", -1)));
        }
        return values;
    }

    public static <T> void saveData(Path filePath, DataFactory<T> factory, Collection<T> values) throws IOException {
        try (BufferedWriter writer = Files.newWriter(filePath.toFile(), StandardCharsets.UTF_8);){
            for (T value : values) {
                String[] fields = factory.serialize(value);
                if (fields == null) continue;
                StringBuilder sb = new StringBuilder();
                for (String field : fields) {
                    if (field == null) {
                        sb.append("\t");
                        continue;
                    }
                    sb.append("\t").append(field);
                }
                writer.write(sb.substring(1));
                writer.write("\n");
            }
        }
    }

    public static Map<ClassReference.Handle, ClassReference> loadClasses() {
        try {
            HashMap<ClassReference.Handle, ClassReference> classMap = new HashMap<ClassReference.Handle, ClassReference>();
            for (ClassReference classReference : DataLoader.loadData(Paths.get("classes.dat", new String[0]), new ClassReference.Factory())) {
                classMap.put(classReference.getHandle(), classReference);
            }
            return classMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<MethodReference.Handle, MethodReference> loadMethods() {
        try {
            HashMap<MethodReference.Handle, MethodReference> methodMap = new HashMap<MethodReference.Handle, MethodReference>();
            for (MethodReference methodReference : DataLoader.loadData(Paths.get("methods.dat", new String[0]), new MethodReference.Factory())) {
                methodMap.put(methodReference.getHandle(), methodReference);
            }
            return methodMap;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

