/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector.data;

import gadgetinspector.data.DataFactory;

public class ClassReference {
    private final String name;
    private final String superClass;
    private final String[] interfaces;
    private final boolean isInterface;
    private final Member[] members;

    public ClassReference(String name, String superClass, String[] interfaces, boolean isInterface, Member[] members) {
        this.name = name;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.isInterface = isInterface;
        this.members = members;
    }

    public String getName() {
        return this.name;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public Member[] getMembers() {
        return this.members;
    }

    public Handle getHandle() {
        return new Handle(this.name);
    }

    public static class Member {
        private final String name;
        private final int modifiers;
        private final Handle type;

        public Member(String name, int modifiers, Handle type) {
            this.name = name;
            this.modifiers = modifiers;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public Handle getType() {
            return this.type;
        }
    }

    public static class Handle {
        private final String name;

        public Handle(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Handle handle = (Handle)o;
            return this.name != null ? this.name.equals(handle.name) : handle.name == null;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }

    public static class Factory
    implements DataFactory<ClassReference> {
        @Override
        public ClassReference parse(String[] fields) {
            String[] interfaces = fields[2].equals("") ? new String[]{} : fields[2].split(",");
            String[] memberEntries = fields[4].split("!");
            Member[] members = new Member[memberEntries.length / 3];
            for (int i = 0; i < members.length; ++i) {
                members[i] = new Member(memberEntries[3 * i], Integer.parseInt(memberEntries[3 * i + 1]), new Handle(memberEntries[3 * i + 2]));
            }
            return new ClassReference(fields[0], fields[1].equals("") ? null : fields[1], interfaces, Boolean.parseBoolean(fields[3]), members);
        }

        @Override
        public String[] serialize(ClassReference obj) {
            String interfaces;
            if (obj.interfaces.length > 0) {
                StringBuilder interfacesSb = new StringBuilder();
                for (String iface : obj.interfaces) {
                    interfacesSb.append(",").append(iface);
                }
                interfaces = interfacesSb.substring(1);
            } else {
                interfaces = "";
            }
            StringBuilder members = new StringBuilder();
            for (Member member : obj.members) {
                members.append("!").append(member.getName()).append("!").append(Integer.toString(member.getModifiers())).append("!").append(member.getType().getName());
            }
            return new String[]{obj.name, obj.superClass, interfaces, Boolean.toString(obj.isInterface), members.length() == 0 ? null : members.substring(1)};
        }
    }
}

