/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassLoader getWarClassLoader(Path warPath) throws IOException {
        Path tmpDir = Files.createTempDirectory("exploded-war", new FileAttribute[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Util.deleteDirectory(tmpDir);
            }
            catch (IOException e) {
                LOGGER.error("Error cleaning up temp directory " + tmpDir.toString(), e);
            }
        }));
        try (JarInputStream jarInputStream = new JarInputStream(Files.newInputStream(warPath, new OpenOption[0]));){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                Path fullPath = tmpDir.resolve(jarEntry.getName());
                if (jarEntry.isDirectory()) continue;
                Path dirName = fullPath.getParent();
                if (dirName == null) {
                    throw new IllegalStateException("Parent of item is outside temp directory.");
                }
                if (!Files.exists(dirName, new LinkOption[0])) {
                    Files.createDirectories(dirName, new FileAttribute[0]);
                }
                OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);
                try {
                    Util.copy(jarInputStream, outputStream);
                }
                finally {
                    if (outputStream == null) continue;
                    outputStream.close();
                }
            }
        }
        ArrayList<URL> classPathUrls = new ArrayList<URL>();
        classPathUrls.add(tmpDir.resolve("WEB-INF/classes").toUri().toURL());
        Files.list(tmpDir.resolve("WEB-INF/lib")).forEach(p -> {
            try {
                classPathUrls.add(p.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        });
        return new URLClassLoader(classPathUrls.toArray(new URL[classPathUrls.size()]));
    }

    public static ClassLoader getJarClassLoader(Path ... jarPaths) throws IOException {
        ArrayList<URL> classPathUrls = new ArrayList<URL>(jarPaths.length);
        for (Path jarPath : jarPaths) {
            if (!Files.exists(jarPath, new LinkOption[0]) || Files.isDirectory(jarPath, new LinkOption[0])) {
                throw new IllegalArgumentException("Path \"" + jarPath + "\" is not a path to a file.");
            }
            classPathUrls.add(jarPath.toUri().toURL());
        }
        URLClassLoader classLoader = new URLClassLoader(classPathUrls.toArray(new URL[classPathUrls.size()]));
        return classLoader;
    }

    public static void deleteDirectory(Path root) throws IOException {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, n);
        }
    }
}

