/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector;

import gadgetinspector.ClassResourceEnumerator;
import gadgetinspector.SerializableDecider;
import gadgetinspector.TaintTrackingMethodVisitor;
import gadgetinspector.Util;
import gadgetinspector.config.GIConfig;
import gadgetinspector.config.JavaDeserializationConfig;
import gadgetinspector.data.ClassReference;
import gadgetinspector.data.DataFactory;
import gadgetinspector.data.DataLoader;
import gadgetinspector.data.InheritanceMap;
import gadgetinspector.data.MethodReference;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassthroughDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(PassthroughDiscovery.class);
    private final Map<MethodReference.Handle, Set<MethodReference.Handle>> methodCalls = new HashMap<MethodReference.Handle, Set<MethodReference.Handle>>();
    private Map<MethodReference.Handle, Set<Integer>> passthroughDataflow;

    public void discover(ClassResourceEnumerator classResourceEnumerator, GIConfig config) throws IOException {
        Map<MethodReference.Handle, MethodReference> methodMap = DataLoader.loadMethods();
        Map<ClassReference.Handle, ClassReference> classMap = DataLoader.loadClasses();
        InheritanceMap inheritanceMap = InheritanceMap.load();
        Map<String, ClassResourceEnumerator.ClassResource> classResourceByName = this.discoverMethodCalls(classResourceEnumerator);
        List<MethodReference.Handle> sortedMethods = this.topologicallySortMethodCalls();
        this.passthroughDataflow = PassthroughDiscovery.calculatePassthroughDataflow(classResourceByName, classMap, inheritanceMap, sortedMethods, config.getSerializableDecider(methodMap, inheritanceMap));
    }

    private Map<String, ClassResourceEnumerator.ClassResource> discoverMethodCalls(ClassResourceEnumerator classResourceEnumerator) throws IOException {
        HashMap<String, ClassResourceEnumerator.ClassResource> classResourcesByName = new HashMap<String, ClassResourceEnumerator.ClassResource>();
        for (ClassResourceEnumerator.ClassResource classResource : classResourceEnumerator.getAllClasses()) {
            InputStream in = classResource.getInputStream();
            try {
                ClassReader cr = new ClassReader(in);
                try {
                    MethodCallDiscoveryClassVisitor visitor = new MethodCallDiscoveryClassVisitor(393216);
                    cr.accept(visitor, 8);
                    classResourcesByName.put(visitor.getName(), classResource);
                }
                catch (Exception e) {
                    LOGGER.error("Error analyzing: " + classResource.getName(), e);
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
        return classResourcesByName;
    }

    private List<MethodReference.Handle> topologicallySortMethodCalls() {
        HashMap<MethodReference.Handle, Set<MethodReference.Handle>> outgoingReferences = new HashMap<MethodReference.Handle, Set<MethodReference.Handle>>();
        for (Map.Entry<MethodReference.Handle, Set<MethodReference.Handle>> entry : this.methodCalls.entrySet()) {
            MethodReference.Handle method = entry.getKey();
            outgoingReferences.put(method, new HashSet(entry.getValue()));
        }
        LOGGER.debug("Performing topological sort...");
        HashSet<MethodReference.Handle> dfsStack = new HashSet<MethodReference.Handle>();
        HashSet<MethodReference.Handle> visitedNodes = new HashSet<MethodReference.Handle>();
        ArrayList<MethodReference.Handle> sortedMethods = new ArrayList<MethodReference.Handle>(outgoingReferences.size());
        for (MethodReference.Handle root : outgoingReferences.keySet()) {
            PassthroughDiscovery.dfsTsort(outgoingReferences, sortedMethods, visitedNodes, dfsStack, root);
        }
        LOGGER.debug(String.format("Outgoing references %d, sortedMethods %d", outgoingReferences.size(), sortedMethods.size()));
        return sortedMethods;
    }

    private static Map<MethodReference.Handle, Set<Integer>> calculatePassthroughDataflow(Map<String, ClassResourceEnumerator.ClassResource> classResourceByName, Map<ClassReference.Handle, ClassReference> classMap, InheritanceMap inheritanceMap, List<MethodReference.Handle> sortedMethods, SerializableDecider serializableDecider) throws IOException {
        HashMap<MethodReference.Handle, Set<Integer>> passthroughDataflow = new HashMap<MethodReference.Handle, Set<Integer>>();
        for (MethodReference.Handle method : sortedMethods) {
            if (method.getName().equals("<clinit>")) continue;
            ClassResourceEnumerator.ClassResource classResource = classResourceByName.get(method.getClassReference().getName());
            try {
                InputStream inputStream = classResource.getInputStream();
                try {
                    ClassReader cr = new ClassReader(inputStream);
                    try {
                        PassthroughDataflowClassVisitor cv = new PassthroughDataflowClassVisitor(classMap, inheritanceMap, passthroughDataflow, serializableDecider, 393216, method);
                        cr.accept(cv, 8);
                        passthroughDataflow.put(method, cv.getReturnTaint());
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception analyzing " + method.getClassReference().getName(), e);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Unable to analyze " + method.getClassReference().getName(), e);
            }
        }
        return passthroughDataflow;
    }

    public void save() throws IOException {
        if (this.passthroughDataflow == null) {
            throw new IllegalStateException("Save called before discover()");
        }
        DataLoader.saveData(Paths.get("passthrough.dat", new String[0]), new PassThroughFactory(), this.passthroughDataflow.entrySet());
    }

    public static Map<MethodReference.Handle, Set<Integer>> load() throws IOException {
        HashMap<MethodReference.Handle, Set<Integer>> passthroughDataflow = new HashMap<MethodReference.Handle, Set<Integer>>();
        for (Map.Entry<MethodReference.Handle, Set<Integer>> entry : DataLoader.loadData(Paths.get("passthrough.dat", new String[0]), new PassThroughFactory())) {
            passthroughDataflow.put(entry.getKey(), entry.getValue());
        }
        return passthroughDataflow;
    }

    private static void dfsTsort(Map<MethodReference.Handle, Set<MethodReference.Handle>> outgoingReferences, List<MethodReference.Handle> sortedMethods, Set<MethodReference.Handle> visitedNodes, Set<MethodReference.Handle> stack, MethodReference.Handle node) {
        if (stack.contains(node)) {
            return;
        }
        if (visitedNodes.contains(node)) {
            return;
        }
        Set<MethodReference.Handle> outgoingRefs = outgoingReferences.get(node);
        if (outgoingRefs == null) {
            return;
        }
        stack.add(node);
        for (MethodReference.Handle child : outgoingRefs) {
            PassthroughDiscovery.dfsTsort(outgoingReferences, sortedMethods, visitedNodes, stack, child);
        }
        stack.remove(node);
        visitedNodes.add(node);
        sortedMethods.add(node);
    }

    public static void main(String[] args) throws Exception {
        ClassLoader classLoader = Util.getWarClassLoader(Paths.get(args[0], new String[0]));
        PassthroughDiscovery passthroughDiscovery = new PassthroughDiscovery();
        passthroughDiscovery.discover(new ClassResourceEnumerator(classLoader), new JavaDeserializationConfig());
        passthroughDiscovery.save();
    }

    private class MethodCallDiscoveryClassVisitor
    extends ClassVisitor {
        private String name;

        public MethodCallDiscoveryClassVisitor(int api) {
            super(api);
            this.name = null;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            if (this.name != null) {
                throw new IllegalStateException("ClassVisitor already visited a class!");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            MethodCallDiscoveryMethodVisitor modelGeneratorMethodVisitor = new MethodCallDiscoveryMethodVisitor(this.api, mv, this.name, name, desc);
            return new JSRInlinerAdapter(modelGeneratorMethodVisitor, access, name, desc, signature, exceptions);
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
        }
    }

    private static class PassthroughDataflowClassVisitor
    extends ClassVisitor {
        Map<ClassReference.Handle, ClassReference> classMap;
        private final MethodReference.Handle methodToVisit;
        private final InheritanceMap inheritanceMap;
        private final Map<MethodReference.Handle, Set<Integer>> passthroughDataflow;
        private final SerializableDecider serializableDecider;
        private String name;
        private PassthroughDataflowMethodVisitor passthroughDataflowMethodVisitor;

        public PassthroughDataflowClassVisitor(Map<ClassReference.Handle, ClassReference> classMap, InheritanceMap inheritanceMap, Map<MethodReference.Handle, Set<Integer>> passthroughDataflow, SerializableDecider serializableDecider, int api, MethodReference.Handle methodToVisit) {
            super(api);
            this.classMap = classMap;
            this.inheritanceMap = inheritanceMap;
            this.methodToVisit = methodToVisit;
            this.passthroughDataflow = passthroughDataflow;
            this.serializableDecider = serializableDecider;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.name = name;
            if (!this.name.equals(this.methodToVisit.getClassReference().getName())) {
                throw new IllegalStateException("Expecting to visit " + this.methodToVisit.getClassReference().getName() + " but instead got " + this.name);
            }
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!name.equals(this.methodToVisit.getName()) || !desc.equals(this.methodToVisit.getDesc())) {
                return null;
            }
            if (this.passthroughDataflowMethodVisitor != null) {
                throw new IllegalStateException("Constructing passthroughDataflowMethodVisitor twice!");
            }
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            this.passthroughDataflowMethodVisitor = new PassthroughDataflowMethodVisitor(this.classMap, this.inheritanceMap, this.passthroughDataflow, this.serializableDecider, this.api, mv, this.name, access, name, desc, signature, exceptions);
            return new JSRInlinerAdapter(this.passthroughDataflowMethodVisitor, access, name, desc, signature, exceptions);
        }

        public Set<Integer> getReturnTaint() {
            if (this.passthroughDataflowMethodVisitor == null) {
                throw new IllegalStateException("Never constructed the passthroughDataflowmethodVisitor!");
            }
            return this.passthroughDataflowMethodVisitor.returnTaint;
        }
    }

    public static class PassThroughFactory
    implements DataFactory<Map.Entry<MethodReference.Handle, Set<Integer>>> {
        @Override
        public Map.Entry<MethodReference.Handle, Set<Integer>> parse(String[] fields) {
            ClassReference.Handle clazz = new ClassReference.Handle(fields[0]);
            MethodReference.Handle method = new MethodReference.Handle(clazz, fields[1], fields[2]);
            HashSet<Integer> passthroughArgs = new HashSet<Integer>();
            for (String arg : fields[3].split(",")) {
                if (arg.length() <= 0) continue;
                passthroughArgs.add(Integer.parseInt(arg));
            }
            return new AbstractMap.SimpleEntry<MethodReference.Handle, Set<Integer>>(method, passthroughArgs);
        }

        @Override
        public String[] serialize(Map.Entry<MethodReference.Handle, Set<Integer>> entry) {
            if (entry.getValue().size() == 0) {
                return null;
            }
            String[] fields = new String[4];
            fields[0] = entry.getKey().getClassReference().getName();
            fields[1] = entry.getKey().getName();
            fields[2] = entry.getKey().getDesc();
            StringBuilder sb = new StringBuilder();
            for (Integer arg : entry.getValue()) {
                sb.append(Integer.toString(arg));
                sb.append(",");
            }
            fields[3] = sb.toString();
            return fields;
        }
    }

    private static class PassthroughDataflowMethodVisitor
    extends TaintTrackingMethodVisitor<Integer> {
        private final Map<ClassReference.Handle, ClassReference> classMap;
        private final InheritanceMap inheritanceMap;
        private final Map<MethodReference.Handle, Set<Integer>> passthroughDataflow;
        private final SerializableDecider serializableDecider;
        private final int access;
        private final String desc;
        private final Set<Integer> returnTaint;

        public PassthroughDataflowMethodVisitor(Map<ClassReference.Handle, ClassReference> classMap, InheritanceMap inheritanceMap, Map<MethodReference.Handle, Set<Integer>> passthroughDataflow, SerializableDecider serializableDeciderMap, int api, MethodVisitor mv, String owner, int access, String name, String desc, String signature, String[] exceptions) {
            super(inheritanceMap, passthroughDataflow, api, mv, owner, access, name, desc, signature, exceptions);
            this.classMap = classMap;
            this.inheritanceMap = inheritanceMap;
            this.passthroughDataflow = passthroughDataflow;
            this.serializableDecider = serializableDeciderMap;
            this.access = access;
            this.desc = desc;
            this.returnTaint = new HashSet<Integer>();
        }

        @Override
        public void visitCode() {
            super.visitCode();
            int localIndex = 0;
            int argIndex = 0;
            if ((this.access & 8) == 0) {
                this.setLocalTaint(localIndex, argIndex);
                ++localIndex;
                ++argIndex;
            }
            for (Type argType : Type.getArgumentTypes(this.desc)) {
                this.setLocalTaint(localIndex, argIndex);
                localIndex += argType.getSize();
                ++argIndex;
            }
        }

        @Override
        public void visitInsn(int opcode) {
            switch (opcode) {
                case 172: 
                case 174: 
                case 176: {
                    this.returnTaint.addAll(this.getStackTaint(0));
                    break;
                }
                case 173: 
                case 175: {
                    this.returnTaint.addAll(this.getStackTaint(1));
                    break;
                }
                case 177: {
                    break;
                }
            }
            super.visitInsn(opcode);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            switch (opcode) {
                case 178: {
                    break;
                }
                case 179: {
                    break;
                }
                case 180: {
                    Type type = Type.getType(desc);
                    if (type.getSize() != 1) break;
                    Boolean isTransient = null;
                    if (!PassthroughDataflowMethodVisitor.couldBeSerialized(this.serializableDecider, this.inheritanceMap, new ClassReference.Handle(type.getInternalName()))) {
                        isTransient = Boolean.TRUE;
                    } else {
                        ClassReference clazz = this.classMap.get(new ClassReference.Handle(owner));
                        while (clazz != null) {
                            for (ClassReference.Member member : clazz.getMembers()) {
                                if (!member.getName().equals(name)) continue;
                                isTransient = (member.getModifiers() & 0x80) != 0;
                                break;
                            }
                            if (isTransient != null) break;
                            clazz = this.classMap.get(new ClassReference.Handle(clazz.getSuperClass()));
                        }
                    }
                    Set taint = !Boolean.TRUE.equals(isTransient) ? this.getStackTaint(0) : new HashSet();
                    super.visitFieldInsn(opcode, owner, name, desc);
                    this.setStackTaint(0, taint);
                    return;
                }
                case 181: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported opcode: " + opcode);
                }
            }
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            Set resultTaint;
            Type[] argTypes = Type.getArgumentTypes(desc);
            if (opcode != 184) {
                Type[] extendedArgTypes = new Type[argTypes.length + 1];
                System.arraycopy(argTypes, 0, extendedArgTypes, 1, argTypes.length);
                extendedArgTypes[0] = Type.getObjectType(owner);
                argTypes = extendedArgTypes;
            }
            int retSize = Type.getReturnType(desc).getSize();
            switch (opcode) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    ArrayList argTaint = new ArrayList(argTypes.length);
                    for (int i = 0; i < argTypes.length; ++i) {
                        argTaint.add(null);
                    }
                    int stackIndex = 0;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        if (argType.getSize() > 0) {
                            argTaint.set(argTypes.length - 1 - i, this.getStackTaint(stackIndex + argType.getSize() - 1));
                        }
                        stackIndex += argType.getSize();
                    }
                    resultTaint = name.equals("<init>") ? (Set)argTaint.get(0) : new HashSet();
                    Set<Integer> passthrough = this.passthroughDataflow.get(new MethodReference.Handle(new ClassReference.Handle(owner), name, desc));
                    if (passthrough == null) break;
                    for (Integer passthroughDataflowArg : passthrough) {
                        resultTaint.addAll((Collection)argTaint.get(passthroughDataflowArg));
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported opcode: " + opcode);
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (retSize > 0) {
                this.getStackTaint(retSize - 1).addAll(resultTaint);
            }
        }
    }

    private class MethodCallDiscoveryMethodVisitor
    extends MethodVisitor {
        private final Set<MethodReference.Handle> calledMethods;

        public MethodCallDiscoveryMethodVisitor(int api, MethodVisitor mv, String owner, String name, String desc) {
            super(api, mv);
            this.calledMethods = new HashSet<MethodReference.Handle>();
            PassthroughDiscovery.this.methodCalls.put(new MethodReference.Handle(new ClassReference.Handle(owner), name, desc), this.calledMethods);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.calledMethods.add(new MethodReference.Handle(new ClassReference.Handle(owner), name, desc));
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

