/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector;

import gadgetinspector.CallGraphDiscovery;
import gadgetinspector.ClassResourceEnumerator;
import gadgetinspector.GadgetChainDiscovery;
import gadgetinspector.MethodDiscovery;
import gadgetinspector.PassthroughDiscovery;
import gadgetinspector.SourceDiscovery;
import gadgetinspector.Util;
import gadgetinspector.config.ConfigRepository;
import gadgetinspector.config.GIConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GadgetInspector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GadgetInspector.class);

    private static void printUsage() {
        System.out.println("Usage:\n  Pass either a single argument which will be interpreted as a WAR, or pass any number of arguments which will be intepretted as a list of JARs forming a classpath.");
    }

    public static void main(String[] args) throws Exception {
        ClassLoader classLoader;
        String arg;
        int argIndex;
        if (args.length == 0) {
            GadgetInspector.printUsage();
            System.exit(1);
        }
        GadgetInspector.configureLogging();
        boolean resume = false;
        GIConfig config = ConfigRepository.getConfig("jserial");
        for (argIndex = 0; argIndex < args.length && (arg = args[argIndex]).startsWith("--"); ++argIndex) {
            if (arg.equals("--resume")) {
                resume = true;
                continue;
            }
            if (arg.equals("--config")) {
                if ((config = ConfigRepository.getConfig(args[++argIndex])) != null) continue;
                throw new IllegalArgumentException("Invalid config name: " + args[argIndex]);
            }
            throw new IllegalArgumentException("Unexpected argument: " + arg);
        }
        if (args.length == argIndex + 1 && args[argIndex].toLowerCase().endsWith(".war")) {
            Path path = Paths.get(args[argIndex], new String[0]);
            LOGGER.info("Using WAR classpath: " + path);
            classLoader = Util.getWarClassLoader(path);
        } else {
            Object[] jarPaths = new Path[args.length - argIndex];
            for (int i = 0; i < args.length - argIndex; ++i) {
                Path path = Paths.get(args[argIndex + i], new String[0]).toAbsolutePath();
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new IllegalArgumentException("Invalid jar path: " + path);
                }
                jarPaths[i] = path;
            }
            LOGGER.info("Using classpath: " + Arrays.toString(jarPaths));
            classLoader = Util.getJarClassLoader((Path[])jarPaths);
        }
        ClassResourceEnumerator classResourceEnumerator = new ClassResourceEnumerator(classLoader);
        if (!resume) {
            LOGGER.info("Deleting stale data...");
            for (String datFile : Arrays.asList("classes.dat", "methods.dat", "inheritanceMap.dat", "passthrough.dat", "callgraph.dat", "sources.dat", "methodimpl.dat")) {
                Path path = Paths.get(datFile, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) continue;
                Files.delete(path);
            }
        }
        if (!(Files.exists(Paths.get("classes.dat", new String[0]), new LinkOption[0]) && Files.exists(Paths.get("methods.dat", new String[0]), new LinkOption[0]) && Files.exists(Paths.get("inheritanceMap.dat", new String[0]), new LinkOption[0]))) {
            LOGGER.info("Running method discovery...");
            MethodDiscovery methodDiscovery = new MethodDiscovery();
            methodDiscovery.discover(classResourceEnumerator);
            methodDiscovery.save();
        }
        if (!Files.exists(Paths.get("passthrough.dat", new String[0]), new LinkOption[0])) {
            LOGGER.info("Analyzing methods for passthrough dataflow...");
            PassthroughDiscovery passthroughDiscovery = new PassthroughDiscovery();
            passthroughDiscovery.discover(classResourceEnumerator, config);
            passthroughDiscovery.save();
        }
        if (!Files.exists(Paths.get("callgraph.dat", new String[0]), new LinkOption[0])) {
            LOGGER.info("Analyzing methods in order to build a call graph...");
            CallGraphDiscovery callGraphDiscovery = new CallGraphDiscovery();
            callGraphDiscovery.discover(classResourceEnumerator, config);
            callGraphDiscovery.save();
        }
        if (!Files.exists(Paths.get("sources.dat", new String[0]), new LinkOption[0])) {
            LOGGER.info("Discovering gadget chain source methods...");
            SourceDiscovery sourceDiscovery = config.getSourceDiscovery();
            sourceDiscovery.discover();
            sourceDiscovery.save();
        }
        LOGGER.info("Searching call graph for gadget chains...");
        GadgetChainDiscovery gadgetChainDiscovery = new GadgetChainDiscovery(config);
        gadgetChainDiscovery.discover();
        LOGGER.info("Analysis complete!");
    }

    private static void configureLogging() {
        ConsoleAppender console = new ConsoleAppender();
        String PATTERN = "%d %c [%p] %m%n";
        console.setLayout(new PatternLayout(PATTERN));
        console.setThreshold(Level.DEBUG);
        console.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender(console);
    }
}

