/*
 * Decompiled with CFR 0.152.
 */
package gadgetinspector;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collection;

public class ClassResourceEnumerator {
    private final ClassLoader classLoader;

    public ClassResourceEnumerator(ClassLoader classLoader) throws IOException {
        this.classLoader = classLoader;
    }

    public Collection<ClassResource> getAllClasses() throws IOException {
        ArrayList<ClassResource> result = new ArrayList<ClassResource>(this.getRuntimeClasses());
        for (ClassPath.ClassInfo classInfo : ClassPath.from(this.classLoader).getAllClasses()) {
            result.add(new ClassLoaderClassResource(this.classLoader, classInfo.getResourceName()));
        }
        return result;
    }

    private Collection<ClassResource> getRuntimeClasses() throws IOException {
        URL stringClassUrl = Object.class.getResource("String.class");
        URLConnection connection = stringClassUrl.openConnection();
        ArrayList<ClassResource> result = new ArrayList<ClassResource>();
        if (connection instanceof JarURLConnection) {
            URL runtimeUrl = ((JarURLConnection)connection).getJarFileURL();
            URLClassLoader classLoader = new URLClassLoader(new URL[]{runtimeUrl});
            for (ClassPath.ClassInfo classInfo : ClassPath.from(classLoader).getAllClasses()) {
                result.add(new ClassLoaderClassResource(classLoader, classInfo.getResourceName()));
            }
            return result;
        }
        try {
            FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
            Files.walk(fs.getPath("/", new String[0]), new FileVisitOption[0]).forEach(p -> {
                if (p.toString().toLowerCase().endsWith(".class")) {
                    result.add(new PathClassResource((Path)p));
                }
            });
        }
        catch (ProviderNotFoundException providerNotFoundException) {
            // empty catch block
        }
        return result;
    }

    private static class ClassLoaderClassResource
    implements ClassResource {
        private final ClassLoader classLoader;
        private final String resourceName;

        private ClassLoaderClassResource(ClassLoader classLoader, String resourceName) {
            this.classLoader = classLoader;
            this.resourceName = resourceName;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.classLoader.getResourceAsStream(this.resourceName);
        }

        @Override
        public String getName() {
            return this.resourceName;
        }
    }

    private static class PathClassResource
    implements ClassResource {
        private final Path path;

        private PathClassResource(Path path) {
            this.path = path;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        @Override
        public String getName() {
            return this.path.toString();
        }
    }

    public static interface ClassResource {
        public InputStream getInputStream() throws IOException;

        public String getName();
    }
}

